/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.FailureScenario;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class FailureScenarioStaticImpl {
    public static List<ExecutionUnit> getSortedEcuList(FailureScenario fs) {
        ArrayList<ExecutionUnit> rval = new ArrayList<ExecutionUnit>();
        EMap<ExecutionUnit, Boolean> ecuHealthMap = fs.getEcuHealthMap();
        rval.addAll(ecuHealthMap.keySet());
        Collections.sort(rval, new Comparator<ExecutionUnit>(){

            @Override
            public int compare(ExecutionUnit e1, ExecutionUnit e2) {
                return e1.getName().compareTo(e2.getName());
            }
        });
        return rval;
    }

    public static EList<ExecutionUnit> getDeadEcus(FailureScenario fs) {
        EMap<ExecutionUnit, Boolean> ecuHealthMap = fs.getEcuHealthMap();
        List<ExecutionUnit> ecus = FailureScenarioStaticImpl.getSortedEcuList(fs);
        return EcoreUtils.pickInstanceOf(e -> (Boolean)ecuHealthMap.get(e) == false, ecus);
    }

    public static EList<ExecutionUnit> getHealthyEcus(FailureScenario fs) {
        EMap<ExecutionUnit, Boolean> ecuHealthMap = fs.getEcuHealthMap();
        List<ExecutionUnit> ecus = FailureScenarioStaticImpl.getSortedEcuList(fs);
        return EcoreUtils.pickInstanceOf(e -> (Boolean)ecuHealthMap.get(e), ecus);
    }

    public static String toString(FailureScenario fs) {
        List<ExecutionUnit> sortedEcuList = FailureScenarioStaticImpl.getSortedEcuList(fs);
        return "<" + sortedEcuList.stream().map(ecu -> (Boolean)fs.getEcuHealthMap().get(ecu) != false ? "1" : "0").collect(Collectors.joining()) + ">";
    }

    public static boolean edgeExists(FailureScenario fs1, FailureScenario fs2) {
        Iterator<ExecutionUnit> fs1Itr = FailureScenarioStaticImpl.getSortedEcuList(fs1).iterator();
        Iterator<ExecutionUnit> fs2Itr = FailureScenarioStaticImpl.getSortedEcuList(fs2).iterator();
        boolean hasSeenDegradation = false;
        if (fs1Itr != null && fs2Itr != null) {
            while (fs1Itr.hasNext() && fs2Itr.hasNext()) {
                Boolean v1 = (Boolean)fs1.getEcuHealthMap().get((Object)fs1Itr.next());
                Boolean v2 = (Boolean)fs2.getEcuHealthMap().get((Object)fs2Itr.next());
                if (!v1.booleanValue() && v2.booleanValue()) {
                    return false;
                }
                if (!v1.booleanValue() || v2.booleanValue()) continue;
                if (hasSeenDegradation) {
                    return false;
                }
                hasSeenDegradation = true;
            }
        }
        return hasSeenDegradation;
    }
}

