/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.model.impl;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.utils.PlatformModelElementFactory;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.kernel.model.INamedElement;

public class PlatformConnectorUnitStaticImpl {
    private static final String INT_ELEMENT_SUFFIX = "_FAKE_COPY";

    public static void specialCopyHook(PlatformConnectorUnit connector, Map<EObject, EObject> copyMap) {
        for (TransmissionConnection c : connector.getIncomingTransmissionConnections()) {
            if ((PlatformConnectorUnit)copyMap.get(c.getSource()) == null) continue;
            PlatformConnectorUnitStaticImpl.copyTransmissionConnection(c, copyMap, PlatformConnectorUnitStaticImpl.findParent(connector, c.getSource(), copyMap));
        }
        for (TransmissionConnection c : connector.getOutgoingTransmissionConnections()) {
            if ((PlatformConnectorUnit)copyMap.get(c.getTarget()) == null) continue;
            PlatformConnectorUnitStaticImpl.copyTransmissionConnection(c, copyMap, PlatformConnectorUnitStaticImpl.findParent(connector, c.getTarget(), copyMap));
        }
    }

    private static IHierarchicElement findParent(PlatformConnectorUnit platformConnectorUnit1, PlatformConnectorUnit platformConnectorUnit2, Map<EObject, EObject> copyMap) {
        IHierarchicElement platformConnectorUnit1Parent;
        IHierarchicElement platformConnectorUnit1Element = PlatformConnectorUnitStaticImpl.obtainCopiedElement(platformConnectorUnit1, copyMap);
        IHierarchicElement platformConnectorUnit2Element = PlatformConnectorUnitStaticImpl.obtainCopiedElement(platformConnectorUnit2, copyMap);
        if (platformConnectorUnit2Element.equals(platformConnectorUnit1Parent = PlatformConnectorUnitStaticImpl.obtainParent(platformConnectorUnit1.getOwner(), copyMap))) {
            return platformConnectorUnit1Parent;
        }
        IHierarchicElement platformConnectorUnit2Parent = PlatformConnectorUnitStaticImpl.obtainParent((IHierarchicElement)platformConnectorUnit2.getPlatformElement(), copyMap);
        if (platformConnectorUnit1Element.equals(platformConnectorUnit2Parent)) {
            return platformConnectorUnit2Parent;
        }
        if (platformConnectorUnit1Parent.equals(platformConnectorUnit2Parent)) {
            return platformConnectorUnit1Parent;
        }
        return null;
    }

    private static IHierarchicElement obtainCopiedElement(PlatformConnectorUnit platformConnectorUnit, Map<EObject, EObject> copyMap) {
        PlatformConnectorUnit platformConnectorUnitCopy = (PlatformConnectorUnit)copyMap.get(platformConnectorUnit);
        IHierarchicElement elementCounterpart = platformConnectorUnitCopy.getOwner();
        IPlatformArchitectureElement element = platformConnectorUnit.getPlatformElement();
        if (elementCounterpart == null) {
            elementCounterpart = (IHierarchicElement)copyMap.get(element);
            if (elementCounterpart == null) {
                elementCounterpart = PlatformConnectorUnitStaticImpl.createInternalHierarchicElement(element.eClass(), ((INamedElement)element).getName());
            }
            elementCounterpart.getConnectors().add((Object)platformConnectorUnitCopy);
        }
        if (!copyMap.containsKey(element)) {
            copyMap.put((EObject)element, (EObject)elementCounterpart);
        }
        return elementCounterpart;
    }

    private static IHierarchicElement obtainParent(IHierarchicElement element, Map<EObject, EObject> copyMap) {
        IHierarchicElement parent = (IHierarchicElement)element.eContainer();
        if (!IHierarchicElement.class.isAssignableFrom(element.getClass())) {
            return null;
        }
        IHierarchicElement elementCopy = (IHierarchicElement)copyMap.get(element);
        IHierarchicElement parentCounterpart = (IHierarchicElement)elementCopy.eContainer();
        if (parentCounterpart == null) {
            if (parent == null) {
                return null;
            }
            parentCounterpart = (IHierarchicElement)copyMap.get(parent);
            if (parentCounterpart == null) {
                parentCounterpart = PlatformConnectorUnitStaticImpl.createInternalHierarchicElement(parent.eClass(), ((INamedElement)parent).getName());
                copyMap.put((EObject)parent, (EObject)parentCounterpart);
            }
            elementCopy.setContainer((IHierarchicElementContainer)parentCounterpart);
        }
        if (!copyMap.containsKey(parent)) {
            copyMap.put((EObject)parent, (EObject)parentCounterpart);
        }
        return parentCounterpart;
    }

    private static IHierarchicElement createInternalHierarchicElement(EClass elemClass, String name) {
        IHierarchicElement element = (IHierarchicElement)EcoreUtil.create((EClass)elemClass);
        if (element instanceof INamedElement) {
            ((INamedElement)element).setName(name + INT_ELEMENT_SUFFIX);
        }
        return element;
    }

    private static void copyTransmissionConnection(TransmissionConnection conn, Map<EObject, EObject> copyMap, IHierarchicElement parent) {
        if (!copyMap.containsKey(conn)) {
            PlatformConnectorUnit src = (PlatformConnectorUnit)copyMap.get(conn.getSource());
            PlatformConnectorUnit target = (PlatformConnectorUnit)copyMap.get(conn.getTarget());
            TransmissionConnection newTransmissionConnection = null;
            if (src instanceof Transceiver && target instanceof Transceiver) {
                newTransmissionConnection = PlatformModelElementFactory.createTransmissionConnection(parent, (Transceiver)src, (Transceiver)target);
            } else if (src instanceof Transmitter && target instanceof Receiver) {
                newTransmissionConnection = PlatformModelElementFactory.createTransmissionConnection(parent, (Transmitter)src, (Receiver)target);
            }
            if (newTransmissionConnection != null) {
                newTransmissionConnection.setComment(conn.getComment());
                copyMap.put((EObject)conn, (EObject)newTransmissionConnection);
            }
        }
    }
}

