/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.model.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.tooling.base.model.element.IModelElement;

public class RouteStaticImpl {
    private static <T extends IModelElement> EList<T> getElementsFromRoute(Route route, Predicate<Segment> segmentPredicate, Function<Segment, T> extractElement) {
        BasicEList rval = new BasicEList();
        LinkedList<Segment> q = new LinkedList<Segment>();
        q.add(route.getRootSegment());
        while (!q.isEmpty()) {
            Segment segment = (Segment)q.poll();
            if (segmentPredicate.test(segment)) {
                rval.add((Object)((IModelElement)extractElement.apply(segment)));
            }
            q.addAll((Collection<Segment>)segment.getNext());
        }
        return rval;
    }

    public static EList<Segment> getAllSegments(Route route) {
        return RouteStaticImpl.getElementsFromRoute(route, s -> true, s -> s);
    }

    public static ExecutionUnit getSenderExecutionUnit(Route route) {
        IModelElement entity = route.getRootSegment().getEntity();
        return entity instanceof ExecutionUnit ? (ExecutionUnit)entity : null;
    }

    public static EList<ExecutionUnit> getReceiverExecutionUnits(Route route) {
        return RouteStaticImpl.getElementsFromRoute(route, s -> s.getNext().isEmpty() && s.getEntity() instanceof ExecutionUnit, s -> (ExecutionUnit)s.getEntity());
    }
}

