/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.tests;

import java.util.Arrays;
import java.util.List;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.generic.GenericExecutionUnit;
import org.fortiss.af3.platform.model.generic.GenericTransceiver;
import org.fortiss.af3.platform.model.generic.GenericTransmissionUnit;
import org.fortiss.af3.platform.utils.PlatformModelElementFactory;
import org.fortiss.af3.platform.utils.RouteUtils;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.junit.Assert;
import org.junit.Test;

public class RouteUtilsTest {
    @Test
    public void test() {
        PlatformArchitecture platformArchitecture = PlatformModelElementFactory.createPlatformArchitecture();
        GenericExecutionUnit e1 = PlatformModelElementFactory.createGenericExecutionUnit("e1");
        platformArchitecture.getContainedElements().add((Object)e1);
        GenericExecutionUnit e2 = PlatformModelElementFactory.createGenericExecutionUnit("e2");
        platformArchitecture.getContainedElements().add((Object)e2);
        GenericTransmissionUnit t1 = PlatformModelElementFactory.createGenericTransmissionUnit("t1");
        platformArchitecture.getContainedElements().add((Object)t1);
        GenericTransmissionUnit t2 = PlatformModelElementFactory.createGenericTransmissionUnit("t2");
        platformArchitecture.getContainedElements().add((Object)t2);
        GenericTransceiver e1_c1 = PlatformModelElementFactory.createGenericTransceiver("e1_c1");
        e1_c1.setOwner((IHierarchicElement)e1);
        GenericTransceiver e1_c2 = PlatformModelElementFactory.createGenericTransceiver("e1_c2");
        e1_c2.setOwner((IHierarchicElement)e1);
        GenericTransceiver e2_c1 = PlatformModelElementFactory.createGenericTransceiver("e2_c1");
        e2_c1.setOwner((IHierarchicElement)e2);
        GenericTransceiver e2_c2 = PlatformModelElementFactory.createGenericTransceiver("e2_c2");
        e2_c2.setOwner((IHierarchicElement)e2);
        GenericTransceiver b1_c1 = PlatformModelElementFactory.createGenericTransceiver("b1_c1");
        b1_c1.setOwner((IHierarchicElement)t1);
        GenericTransceiver b1_c2 = PlatformModelElementFactory.createGenericTransceiver("b1_c2");
        b1_c2.setOwner((IHierarchicElement)t1);
        GenericTransceiver b2_c1 = PlatformModelElementFactory.createGenericTransceiver("b2_c1");
        b2_c1.setOwner((IHierarchicElement)t2);
        GenericTransceiver b2_c2 = PlatformModelElementFactory.createGenericTransceiver("b2_c2");
        b2_c2.setOwner((IHierarchicElement)t2);
        PlatformModelElementFactory.createTransmissionConnection((IHierarchicElement)platformArchitecture, e1_c1, b1_c1);
        PlatformModelElementFactory.createTransmissionConnection((IHierarchicElement)platformArchitecture, e1_c2, b2_c1);
        PlatformModelElementFactory.createTransmissionConnection((IHierarchicElement)platformArchitecture, e2_c1, b1_c2);
        PlatformModelElementFactory.createTransmissionConnection((IHierarchicElement)platformArchitecture, e2_c2, b2_c2);
        List<ExecutionUnit> executionUnits = Arrays.asList(e1, e2);
        List<TransmissionUnit> transmissionUnits = Arrays.asList(t1, t2);
        List<GatewayUnit> gatewayUnits = Arrays.asList(new GatewayUnit[0]);
        List<Route> routes = RouteUtils.extractRoutes(executionUnits, transmissionUnits, gatewayUnits);
        Assert.assertEquals((long)1L, (long)routes.stream().filter(route -> route.getSenderExecutionUnit() == e1 && route.getReceiverExecutionUnits().stream().anyMatch(ecu -> ecu == e1)).count());
        Assert.assertEquals((long)1L, (long)routes.stream().filter(route -> route.getSenderExecutionUnit() == e2 && route.getReceiverExecutionUnits().stream().anyMatch(ecu -> ecu == e2)).count());
        Assert.assertEquals((long)2L, (long)routes.stream().filter(route -> route.getSenderExecutionUnit() == e1 && route.getReceiverExecutionUnits().stream().anyMatch(ecu -> ecu == e2)).count());
        Assert.assertEquals((long)2L, (long)routes.stream().filter(route -> route.getSenderExecutionUnit() == e2 && route.getReceiverExecutionUnits().stream().anyMatch(ecu -> ecu == e1)).count());
    }
}

