/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.allocation.IAllocationService;
import org.fortiss.af3.allocation.model.AllocationEntry;
import org.fortiss.af3.allocation.model.AllocationTable;
import org.fortiss.af3.allocation.model.IAllocationType;
import org.fortiss.af3.expression.model.definitions.Array;
import org.fortiss.af3.expression.model.definitions.BoolTypeDefinition;
import org.fortiss.af3.expression.model.definitions.DoubleTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Enumeration;
import org.fortiss.af3.expression.model.definitions.IntTypeDefinition;
import org.fortiss.af3.expression.model.definitions.Structure;
import org.fortiss.af3.expression.model.definitions.StructureMember;
import org.fortiss.af3.expression.model.types.TDefinedType;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.IArchitectureDomain;
import org.fortiss.af3.platform.model.ICommunicationMaster;
import org.fortiss.af3.platform.model.ICommunicationRole;
import org.fortiss.af3.platform.model.ICommunicationSlave;
import org.fortiss.af3.platform.model.IExecutiveLayerPlatformArchitectureElement;
import org.fortiss.af3.platform.model.ILogicalPlatformArchitectureElement;
import org.fortiss.af3.platform.model.IPhysicalPlatformArchitectureElement;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.IPlatformArchitectureElementType;
import org.fortiss.af3.platform.model.IPlatformExport;
import org.fortiss.af3.platform.model.IPlatformInterface;
import org.fortiss.af3.platform.model.IPlatformPort;
import org.fortiss.af3.platform.model.ISoftwarePlatformArchitectureElement;
import org.fortiss.af3.platform.model.IVirtualizationPlatformArchitectureElement;
import org.fortiss.af3.platform.model.MemoryUnit;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeExecutiveLayer;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeHardwareLayer;
import org.fortiss.af3.platform.model.allocation.IAllocationTypePlatformUnit;
import org.fortiss.af3.platform.model.allocation.IAllocationTypeVirtualizationLayer;
import org.fortiss.af3.platform.model.annotation.EnumerationSize;
import org.fortiss.af3.platform.model.annotation.TypeSize;
import org.fortiss.af3.project.model.typesystem.IType;
import org.fortiss.af3.project.model.typesystem.ITypeDefinition;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class PlatformArchitectureUtils {
    public static List<TransmissionUnit> findAtomicTransmissionUnits(PlatformArchitecture pa) {
        return PlatformArchitectureUtils.findAtomicElements((EObject)pa, TransmissionUnit.class);
    }

    public static List<GatewayUnit> findAllGatewayUnits(PlatformArchitecture pa) {
        return EcoreUtils.getChildrenWithType((EObject)pa, GatewayUnit.class);
    }

    public static List<MemoryUnit> findAllMemoryUnits(PlatformArchitecture pa) {
        return EcoreUtils.getChildrenWithType((EObject)pa, MemoryUnit.class);
    }

    public static List<TransmissionConnection> findAllTransmissionConnections(PlatformArchitecture pa) {
        return EcoreUtils.getChildrenWithType((EObject)pa, TransmissionConnection.class);
    }

    public static List<ExecutionUnit> findAllExecutionUnits(PlatformArchitecture pa) {
        return EcoreUtils.getChildrenWithType((EObject)pa, ExecutionUnit.class);
    }

    public static List<Transceiver> findAtomicExecutionUnitTransceivers(PlatformArchitecture pa) {
        return PlatformArchitectureUtils.findAtomicConnectors((EObject)pa, Transceiver.class, ExecutionUnit.class);
    }

    public static List<IPlatformArchitectureElement> findAllPlatformArchitectureElements(PlatformArchitecture pa) {
        return EcoreUtils.getChildrenWithType((EObject)pa, IPlatformArchitectureElement.class);
    }

    private static <T extends EObject> List<T> findAtomicElements(EObject root, Class<T> clazz) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            if (!clazz.isAssignableFrom(eo.getClass()) || !(eo instanceof IHierarchicElement) || ((IHierarchicElement)eo).getContainedElements().size() != 0) continue;
            result.add(eo);
        }
        return result;
    }

    private static <T extends IConnector> List<T> findAtomicConnectors(EObject root, Class<T> connectorClazz, Class<? extends IHierarchicElement> parentClass) {
        ArrayList<IConnector> result = new ArrayList<IConnector>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject eo = (EObject)iter.next();
            if (!connectorClazz.isAssignableFrom(eo.getClass()) || !parentClass.isAssignableFrom(parentClass) || ((IHierarchicElement)eo.eContainer()).getContainedElements().size() != 0) continue;
            result.add((IConnector)eo);
        }
        return result;
    }

    public static TransmissionUnit findConnectedTransmissionUnit(Transceiver tc) {
        if (tc.eContainer() instanceof TransmissionUnit && ((TransmissionUnit)tc.eContainer()).getContainedElements().size() == 0) {
            return (TransmissionUnit)tc.eContainer();
        }
        if (tc.getOutgoing().size() == 0) {
            return null;
        }
        return PlatformArchitectureUtils.findConnectedTransmissionUnit((Transceiver)((IConnection)tc.getOutgoing().get(0)).getTarget());
    }

    public static ExecutionUnit findConnectedExecutionUnit(Transceiver tc) {
        if (tc.eContainer() instanceof ExecutionUnit && ((ExecutionUnit)tc.eContainer()).getContainedElements().size() == 0) {
            return (ExecutionUnit)tc.eContainer();
        }
        if (tc.getIncoming().size() == 0) {
            return null;
        }
        return PlatformArchitectureUtils.findConnectedExecutionUnit((Transceiver)((IConnection)tc.getIncoming().get(0)).getSource());
    }

    public static void linkTransmissionConnection(TransmissionConnection conn, Transceiver t1, Transceiver t2) {
        if (t1.eContainer() instanceof ExecutionUnit) {
            ExecutionUnit exec = (ExecutionUnit)t1.eContainer();
            if (t2.eContainer() instanceof ExecutionUnit) {
                ExecutionUnit other = (ExecutionUnit)t2.eContainer();
                if (exec == other.eContainer()) {
                    conn.setSource((IConnector)t2);
                    conn.setTarget((IConnector)t1);
                } else if (other == exec.eContainer()) {
                    conn.setSource((IConnector)t1);
                    conn.setTarget((IConnector)t2);
                }
            } else if (t2.eContainer() instanceof TransmissionUnit && exec.eContainer() == t2.eContainer().eContainer()) {
                conn.setSource((IConnector)t1);
                conn.setTarget((IConnector)t2);
            }
        } else if (t1.eContainer() instanceof TransmissionUnit) {
            TransmissionUnit unit = (TransmissionUnit)t1.eContainer();
            if (t2.eContainer() instanceof TransmissionUnit) {
                TransmissionUnit other = (TransmissionUnit)t2.eContainer();
                if (unit == other.eContainer()) {
                    conn.setSource((IConnector)t1);
                    conn.setTarget((IConnector)t2);
                } else if (other == unit.eContainer()) {
                    conn.setSource((IConnector)t2);
                    conn.setTarget((IConnector)t1);
                }
            } else if (t2.eContainer() instanceof ExecutionUnit && unit.eContainer() == t2.eContainer().eContainer()) {
                conn.setSource((IConnector)t2);
                conn.setTarget((IConnector)t1);
            }
        }
    }

    public static <T extends Transceiver> T findFirstTransceiver(Class<T> clazz, ExecutionUnit unit) {
        return (T)((Transceiver)ReflectionUtils.pickInstanceOf(clazz, unit.getTransceiverUnits()));
    }

    public static boolean isPlatformElement(EObject element) {
        return element instanceof IPlatformArchitectureElement;
    }

    public static boolean isVirtualPlatformElement(EObject element) {
        return element instanceof ISoftwarePlatformArchitectureElement || element instanceof ILogicalPlatformArchitectureElement;
    }

    public static boolean isPlatformConnector(EObject connector) {
        return connector instanceof PlatformConnectorUnit;
    }

    public static boolean isMasterPort(EObject connector) {
        return PlatformArchitectureUtils.isPlatformConnector(connector) && connector instanceof ICommunicationMaster && connector instanceof IPlatformPort;
    }

    public static boolean isSlavePort(EObject connector) {
        return PlatformArchitectureUtils.isPlatformConnector(connector) && connector instanceof ICommunicationSlave && connector instanceof IPlatformPort;
    }

    public static boolean isInterface(EObject connector) {
        return PlatformArchitectureUtils.isPlatformConnector(connector) && connector instanceof IPlatformInterface;
    }

    public static boolean isMasterExport(EObject connector) {
        return PlatformArchitectureUtils.isPlatformConnector(connector) && connector instanceof ICommunicationMaster && connector instanceof IPlatformExport;
    }

    private static <T> boolean refinesMarkerInterface(Class<?> clazz, Class<T> markerInterface) {
        if (clazz.equals(markerInterface)) {
            return true;
        }
        boolean rval = false;
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> i = classArray[n2];
            rval = true;
            if (!PlatformArchitectureUtils.refinesMarkerInterface(i, markerInterface)) {
                return false;
            }
            ++n2;
        }
        return rval;
    }

    private static <T> Class<? extends T> getMarkerInterface(Class<?> clazz, Class<T> markerInterface) {
        LinkedHashSet superTypeQueue = new LinkedHashSet();
        superTypeQueue.add(clazz);
        do {
            LinkedHashSet thisLevel = new LinkedHashSet(superTypeQueue);
            superTypeQueue.clear();
            for (Class each : thisLevel) {
                if (PlatformArchitectureUtils.refinesMarkerInterface(each, markerInterface)) {
                    return each;
                }
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != EObject.class) {
                    superTypeQueue.add(superClass);
                }
                Class<?>[] classArray = each.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> eachInt = classArray[n2];
                    superTypeQueue.add(eachInt);
                    ++n2;
                }
            }
        } while (!superTypeQueue.isEmpty());
        return null;
    }

    public static Class<? extends IArchitectureDomain> getArchitectureDomain(Class<? extends IArchitectureDomain> element) {
        return PlatformArchitectureUtils.getMarkerInterface(element, IArchitectureDomain.class);
    }

    public static Class<? extends ICommunicationRole> getCommunicationRole(EObject source, EObject target) {
        Class<ICommunicationRole> sourceRole = PlatformArchitectureUtils.getMarkerInterface(source.getClass(), ICommunicationRole.class);
        Class<ICommunicationRole> targetRole = PlatformArchitectureUtils.getMarkerInterface(target.getClass(), ICommunicationRole.class);
        if (sourceRole != null && targetRole != null) {
            if (sourceRole == targetRole) {
                return sourceRole;
            }
            return ICommunicationRole.class;
        }
        if (sourceRole != null) {
            return sourceRole;
        }
        return targetRole;
    }

    public static List<IHierarchicElement> getConnectedElements(TransmissionUnit tu) {
        ArrayList<IHierarchicElement> results = new ArrayList<IHierarchicElement>();
        for (IConnector c : tu.getConnectors()) {
            for (IConnection con : c.getIncoming()) {
                if (results.contains(con.getSource().getOwner())) continue;
                results.add(con.getSource().getOwner());
            }
            for (IConnection con : c.getOutgoing()) {
                if (results.contains(con.getTarget().getOwner())) continue;
                results.add(con.getTarget().getOwner());
            }
        }
        return results;
    }

    public static int getPlatformArchitectureLevel(EObject platformElement) {
        PlatformArchitecture platformArchitecture = (PlatformArchitecture)KernelModelElementUtils.getParentElement((EObject)platformElement, PlatformArchitecture.class, (boolean)false);
        if (platformArchitecture == null) {
            return -1;
        }
        return EcoreUtils.getModelElementLevel((EObject)platformElement) - EcoreUtils.getModelElementLevel((EObject)platformArchitecture);
    }

    public static Class<? extends IAllocationType> getAllocationTargetType(Class<? extends IPlatformArchitectureElementType> architectureElementType) {
        if (IPhysicalPlatformArchitectureElement.class.isAssignableFrom(architectureElementType)) {
            return IAllocationTypeHardwareLayer.class;
        }
        if (IVirtualizationPlatformArchitectureElement.class.isAssignableFrom(architectureElementType)) {
            return IAllocationTypeVirtualizationLayer.class;
        }
        if (IExecutiveLayerPlatformArchitectureElement.class.isAssignableFrom(architectureElementType)) {
            return IAllocationTypeExecutiveLayer.class;
        }
        return null;
    }

    public static Class<? extends AllocationEntry> getHardwareLayerEntryType(Class<? extends AllocationTable> atType, Class<? extends IAllocationTypePlatformUnit> allocationType) {
        IAllocationService as = IAllocationService.getInstance();
        Collection entryTypes = as.getAllocationEntryTypes(atType, new Class[]{IAllocationTypeHardwareLayer.class, allocationType});
        if (entryTypes.size() != 1) {
            return null;
        }
        Class entryType = (Class)entryTypes.iterator().next();
        return entryType;
    }

    public static Integer getDataTypeSizeBits(IType type, IModelElement platformElement) {
        EList tsSpec = EcoreUtils.pickInstanceOf(TypeSize.class, (List)platformElement.getSpecifications());
        return PlatformArchitectureUtils.getDataTypeSizeBits(type, (Collection<TypeSize>)tsSpec);
    }

    private static Integer getDataTypeSizeBits(IType type, Collection<TypeSize> tsList) {
        if (type instanceof TDefinedType) {
            return PlatformArchitectureUtils.getDataTypeSizeBits((ITypeDefinition)((TDefinedType)type).getDef(), tsList);
        }
        Optional<TypeSize> tSize = tsList.stream().filter(ts -> ts.getAF3Type().isAssignableFrom(type.getClass())).findFirst();
        if (tSize.isPresent()) {
            TypeSize typeSizeSpec = tSize.get();
            return typeSizeSpec.getValueOf(type);
        }
        return 0;
    }

    private static Integer getDataTypeSizeBits(ITypeDefinition type, Collection<TypeSize> tsSpec) {
        if (type instanceof BoolTypeDefinition) {
            IType bType = ((BoolTypeDefinition)type).createIType();
            return PlatformArchitectureUtils.getDataTypeSizeBits(bType, tsSpec);
        }
        if (type instanceof IntTypeDefinition) {
            IType iType = ((IntTypeDefinition)type).createIType();
            return PlatformArchitectureUtils.getDataTypeSizeBits(iType, tsSpec);
        }
        if (type instanceof DoubleTypeDefinition) {
            IType dType = ((DoubleTypeDefinition)type).createIType();
            return PlatformArchitectureUtils.getDataTypeSizeBits(dType, tsSpec);
        }
        if (type instanceof Enumeration) {
            EnumerationSize enumSize = tsSpec.stream().filter(t -> t instanceof EnumerationSize).map(EnumerationSize.class::cast).findAny().get();
            Integer enumSizeVal = (Integer)enumSize.getValue();
            if (enumSizeVal != null && enumSizeVal == 0) {
                int memberSize = ((Enumeration)type).getMembers().size();
                return PlatformArchitectureUtils.ceilLog2(memberSize);
            }
            return enumSizeVal;
        }
        if (type instanceof Array) {
            Array arr = (Array)type;
            return PlatformArchitectureUtils.getDataTypeSizeBits(arr.getType(), tsSpec) * arr.getLength();
        }
        if (type instanceof Structure) {
            int aggregateSize = 0;
            for (StructureMember member : ((Structure)type).getMembers()) {
                aggregateSize += PlatformArchitectureUtils.getDataTypeSizeBits(member.getType(), tsSpec).intValue();
            }
            return aggregateSize;
        }
        return null;
    }

    private static int ceilLog2(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        return 32 - Integer.numberOfLeadingZeros(n - 1);
    }
}

