/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.utils;

import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.platform.model.AF3PlatformFactory;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.Receiver;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.platform.model.Transceiver;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.model.Transmitter;
import org.fortiss.af3.platform.model.allocation.ComponentToExecutionUnitAllocationTable;
import org.fortiss.af3.platform.model.allocation.PlatformAllocationFactory;
import org.fortiss.af3.platform.model.generic.AF3GenericFactory;
import org.fortiss.af3.platform.model.generic.GenericExecutionUnit;
import org.fortiss.af3.platform.model.generic.GenericReceiver;
import org.fortiss.af3.platform.model.generic.GenericTransceiver;
import org.fortiss.af3.platform.model.generic.GenericTransmissionUnit;
import org.fortiss.af3.platform.model.generic.GenericTransmitter;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.kernel.model.IProjectRootElement;

public class PlatformModelElementFactory {
    public static PlatformArchitecture createPlatformArchitecture() {
        return PlatformModelElementFactory.createPlatformArchitecture("Platform Architecture", "");
    }

    public static PlatformArchitecture createPlatformArchitecture(String name, String comment) {
        PlatformArchitecture arch = AF3PlatformFactory.eINSTANCE.createPlatformArchitecture();
        arch.setName(name);
        arch.setComment(comment);
        return arch;
    }

    public static TransmissionConnection createTransmissionConnection() {
        TransmissionConnection tc = AF3PlatformFactory.eINSTANCE.createTransmissionConnection();
        tc.setName("");
        tc.setComment("");
        LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)tc);
        return tc;
    }

    private static TransmissionConnection createTransmissionConnection(IHierarchicElement parent, PlatformConnectorUnit source, PlatformConnectorUnit target) {
        TransmissionConnection conn = PlatformModelElementFactory.createTransmissionConnection();
        parent.getConnections().add((Object)conn);
        conn.setSource((IConnector)source);
        conn.setTarget((IConnector)target);
        return conn;
    }

    public static TransmissionConnection createTransmissionConnection(IHierarchicElement parent, Transceiver source, Transceiver target) {
        return PlatformModelElementFactory.createTransmissionConnection(parent, (PlatformConnectorUnit)source, (PlatformConnectorUnit)target);
    }

    public static TransmissionConnection createTransmissionConnection(IHierarchicElement parent, Transmitter source, Receiver target) {
        return PlatformModelElementFactory.createTransmissionConnection(parent, (PlatformConnectorUnit)source, (PlatformConnectorUnit)target);
    }

    public static GenericExecutionUnit createGenericExecutionUnit(String name) {
        GenericExecutionUnit eu = AF3GenericFactory.eINSTANCE.createGenericExecutionUnit();
        eu.setName(name);
        LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)eu);
        return eu;
    }

    public static GenericTransmissionUnit createGenericTransmissionUnit(String name) {
        GenericTransmissionUnit tu = AF3GenericFactory.eINSTANCE.createGenericTransmissionUnit();
        tu.setName(name);
        LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)tu);
        return tu;
    }

    public static GenericTransmitter createGenericTransmitter(String name) {
        GenericTransmitter trans = AF3GenericFactory.eINSTANCE.createGenericTransmitter();
        trans.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)trans);
        return trans;
    }

    public static GenericTransceiver createGenericTransceiver(String name) {
        GenericTransceiver trans = AF3GenericFactory.eINSTANCE.createGenericTransceiver();
        trans.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)trans);
        return trans;
    }

    public static GenericReceiver createGenericReceiver(String name) {
        GenericReceiver rec = AF3GenericFactory.eINSTANCE.createGenericReceiver();
        rec.setName(name);
        LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)rec);
        return rec;
    }

    public static ComponentToExecutionUnitAllocationTable createComponentToExecutionUnitAllocationTable(String name) {
        ComponentToExecutionUnitAllocationTable ca2pa = PlatformAllocationFactory.eINSTANCE.createComponentToExecutionUnitAllocationTable();
        ca2pa.setName(name);
        return ca2pa;
    }

    public static ComponentToExecutionUnitAllocationTable createComponentToExecutionUnitAllocationTable(String name, ComponentArchitecture ca, PlatformArchitecture pa) {
        ComponentToExecutionUnitAllocationTable ca2pa = PlatformModelElementFactory.createComponentToExecutionUnitAllocationTable(name);
        ca2pa.setSourceView((IProjectRootElement)ca);
        ca2pa.setTargetView(pa);
        return ca2pa;
    }

    public static Segment createSegment(IModelElement entity) {
        Segment segment = AF3PlatformFactory.eINSTANCE.createSegment();
        segment.setEntity(entity);
        return segment;
    }

    public static Route createRoute() {
        Route route = AF3PlatformFactory.eINSTANCE.createRoute();
        return route;
    }
}

