/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.utils;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;

class ResourceConnection {
    private IPlatformResource sourceResource;
    private Map<IPlatformResource, ConnectionType> targetDirectionMap = new HashMap<IPlatformResource, ConnectionType>();
    private static Map<Class<? extends IConnector>, ConnectionType> connectionTypeLUT = Collections.unmodifiableMap(new HashMap<Class<? extends IConnector>, ConnectionType>(){});

    ResourceConnection(IConnector sourceConnector, Collection<IConnector> targetConnectors, Collection<IPlatformResource> allResources) {
        HashSet<IPlatformResource> targetResources = new HashSet<IPlatformResource>();
        HashSet<IPlatformResource> targetElements = new HashSet<IPlatformResource>();
        HashMultimap targetConnsAtElement = HashMultimap.create();
        for (IConnector targetConnector : targetConnectors) {
            targetElements.add((IPlatformResource)targetConnector.getOwner());
            targetConnsAtElement.put((Object)targetConnector.getOwner(), (Object)targetConnector);
        }
        for (IPlatformResource resource : allResources) {
            if (resource == sourceConnector.getOwner()) {
                this.sourceResource = resource;
                continue;
            }
            if (!targetElements.contains(resource)) continue;
            targetResources.add(resource);
            ConnectionType type = ConnectionType.BIDIRECTIONAL;
            boolean firstRoundFlag = true;
            for (IConnector targetConnector : targetConnsAtElement.get((Object)((IHierarchicElement)resource))) {
                if (firstRoundFlag) {
                    firstRoundFlag = false;
                    type = this.getConnectionType(sourceConnector, targetConnector);
                    continue;
                }
                if (type == this.getConnectionType(sourceConnector, targetConnector)) continue;
                type = ConnectionType.BIDIRECTIONAL;
            }
            this.targetDirectionMap.put(resource, type);
        }
    }

    IPlatformResource getSourceResource() {
        return this.sourceResource;
    }

    Collection<IPlatformResource> getTargetResources() {
        return this.targetDirectionMap.keySet();
    }

    ConnectionType getConnectionType(IPlatformResource targetResource) {
        if (this.targetDirectionMap.get(targetResource) != null) {
            return this.targetDirectionMap.get(targetResource);
        }
        return ConnectionType.BIDIRECTIONAL;
    }

    private ConnectionType getConnectionType(IConnector sourceConnector, IConnector targetConnector) {
        ConnectionType connectionTypeSource = connectionTypeLUT.get(sourceConnector.eClass().getInstanceClass());
        ConnectionType connectionTypeTarget = connectionTypeLUT.get(targetConnector.eClass().getInstanceClass());
        if (connectionTypeSource == ConnectionType.OUTGOING && connectionTypeTarget == ConnectionType.INCOMING) {
            return ConnectionType.OUTGOING;
        }
        if (connectionTypeSource == ConnectionType.INCOMING && connectionTypeTarget == ConnectionType.OUTGOING) {
            return ConnectionType.INCOMING;
        }
        if ((connectionTypeSource == ConnectionType.BIDIRECTIONAL || connectionTypeSource == null) && connectionTypeTarget != null && connectionTypeTarget != ConnectionType.BIDIRECTIONAL) {
            return connectionTypeTarget == ConnectionType.INCOMING ? ConnectionType.OUTGOING : ConnectionType.INCOMING;
        }
        if ((connectionTypeTarget == ConnectionType.BIDIRECTIONAL || connectionTypeTarget == null) && connectionTypeSource != null && connectionTypeSource != ConnectionType.BIDIRECTIONAL) {
            return connectionTypeSource;
        }
        return ConnectionType.BIDIRECTIONAL;
    }

    static enum ConnectionType {
        BIDIRECTIONAL,
        INCOMING,
        OUTGOING;

    }
}

