/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.IPlatformCommunicationResource;
import org.fortiss.af3.platform.model.IPlatformExport;
import org.fortiss.af3.platform.model.IPlatformResource;
import org.fortiss.af3.platform.model.Route;
import org.fortiss.af3.platform.model.Segment;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.utils.PlatformModelElementFactory;
import org.fortiss.af3.platform.utils.ResourceConnection;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.alg.shortestpath.EppsteinShortestPathIterator;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.SimpleDirectedGraph;

public class RouteUtils {
    public static List<Route> extractRoutes(Collection<ExecutionUnit> executionUnits, Collection<TransmissionUnit> transmissionUnits, Collection<GatewayUnit> gatewayUnits) {
        SimpleDirectedGraph<IPlatformResource, DefaultEdge> platformGraph = RouteUtils.createGraph(executionUnits, transmissionUnits, gatewayUnits);
        ArrayList<Route> routes = new ArrayList<Route>();
        for (ExecutionUnit ecu1 : executionUnits) {
            block1: for (ExecutionUnit ecu2 : executionUnits) {
                EppsteinShortestPathIterator espi = new EppsteinShortestPathIterator(platformGraph, (Object)ecu1, (Object)ecu2);
                Double weight = null;
                while (espi.hasNext()) {
                    GraphPath path = espi.next();
                    if (weight != null && weight < path.getWeight()) continue block1;
                    weight = path.getWeight();
                    Route route = PlatformModelElementFactory.createRoute();
                    routes.add(route);
                    boolean first = true;
                    Segment lastSegment = null;
                    for (IPlatformResource resource : path.getVertexList()) {
                        IPlatformArchitectureElement element = (IPlatformArchitectureElement)((Object)resource);
                        Segment segment = PlatformModelElementFactory.createSegment((IModelElement)element);
                        if (first) {
                            route.setRootSegment(segment);
                            route.setName("Route_" + element.getName() + "_" + ((INamedElement)path.getEndVertex()).getName());
                            first = false;
                        } else if (lastSegment != null) {
                            lastSegment.getNext().add((Object)segment);
                        }
                        lastSegment = segment;
                    }
                }
            }
        }
        return routes;
    }

    private static SimpleDirectedGraph<IPlatformResource, DefaultEdge> createGraph(Collection<ExecutionUnit> executionUnits, Collection<TransmissionUnit> transmissionUnits, Collection<GatewayUnit> gatewayUnits) {
        SimpleDirectedGraph platformGraph = new SimpleDirectedGraph(DefaultEdge.class);
        Graphs.addAllVertices((Graph)platformGraph, executionUnits);
        Graphs.addAllVertices((Graph)platformGraph, transmissionUnits);
        Graphs.addAllVertices((Graph)platformGraph, gatewayUnits);
        ArrayList<IPlatformResource> allResources = new ArrayList<IPlatformResource>();
        allResources.addAll(executionUnits);
        allResources.addAll(transmissionUnits);
        allResources.addAll(gatewayUnits);
        for (ResourceConnection connection : RouteUtils.getResourceConnections(executionUnits, allResources)) {
            IPlatformResource srcResource = connection.getSourceResource();
            for (IPlatformResource currentReceiverResource : connection.getTargetResources()) {
                if (connection.getConnectionType(currentReceiverResource) == ResourceConnection.ConnectionType.OUTGOING) {
                    platformGraph.addEdge((Object)srcResource, (Object)currentReceiverResource);
                    continue;
                }
                if (connection.getConnectionType(currentReceiverResource) == ResourceConnection.ConnectionType.INCOMING) {
                    platformGraph.addEdge((Object)currentReceiverResource, (Object)srcResource);
                    continue;
                }
                platformGraph.addEdge((Object)srcResource, (Object)currentReceiverResource);
                platformGraph.addEdge((Object)currentReceiverResource, (Object)srcResource);
            }
        }
        return platformGraph;
    }

    private static Collection<ResourceConnection> getResourceConnections(Collection<ExecutionUnit> executionUnits, Collection<IPlatformResource> platformResources) {
        ArrayList<ResourceConnection> rval = new ArrayList<ResourceConnection>();
        LinkedList<IConnector> execUnitConnectors = new LinkedList<IConnector>();
        for (ExecutionUnit execUnit : executionUnits) {
            execUnitConnectors.addAll((Collection<IConnector>)execUnit.getConnectors());
        }
        HashSet<IConnector> visitedConnectors = new HashSet<IConnector>();
        while (!execUnitConnectors.isEmpty()) {
            IConnector sourceConnector = (IConnector)execUnitConnectors.poll();
            visitedConnectors.add(sourceConnector);
            IHierarchicElement sourceElement = sourceConnector.getOwner();
            if (!(sourceElement instanceof ExecutionUnit) && !(sourceElement instanceof GatewayUnit) && !(sourceElement instanceof TransmissionUnit)) continue;
            Collection<IConnector> targetConnectors = RouteUtils.getEffectiveConnectionTargets(sourceConnector, executionUnits);
            ResourceConnection connAdp = new ResourceConnection(sourceConnector, targetConnectors, platformResources);
            rval.add(connAdp);
            visitedConnectors.addAll(targetConnectors);
            ArrayList<IHierarchicElement> targetElements = new ArrayList<IHierarchicElement>();
            for (IConnector currentTargetConnector : targetConnectors) {
                IHierarchicElement target = currentTargetConnector.getOwner();
                if (!platformResources.contains((IPlatformResource)target)) continue;
                targetElements.add(target);
            }
            RouteUtils.determineNextConnectionTargets(execUnitConnectors, visitedConnectors, targetElements, executionUnits);
        }
        return rval;
    }

    private static Collection<IConnector> getEffectiveConnectionTargets(IConnector sourceConnector, Collection<ExecutionUnit> executionUnits) {
        HashSet<IConnector> targetConnectors = new HashSet<IConnector>();
        if (sourceConnector == null) {
            return targetConnectors;
        }
        LinkedList<IConnector> possibleTargetConnectors = new LinkedList<IConnector>();
        HashSet<IConnector> visitedTargetConnectors = new HashSet<IConnector>();
        possibleTargetConnectors.add(sourceConnector);
        while (!possibleTargetConnectors.isEmpty()) {
            IConnector nextTargetConnector = (IConnector)possibleTargetConnectors.poll();
            targetConnectors.addAll(RouteUtils.seekIntraPlatformTargetConnectors(sourceConnector, possibleTargetConnectors, visitedTargetConnectors, nextTargetConnector, executionUnits));
            visitedTargetConnectors.add(nextTargetConnector);
        }
        return targetConnectors;
    }

    private static Collection<IConnector> seekIntraPlatformTargetConnectors(IConnector sourceConnector, LinkedList<IConnector> possibleTargetConnectors, Collection<IConnector> visitedTargetConnectors, IConnector nextTargetConnector, Collection<ExecutionUnit> executionUnits) {
        ArrayList<IConnector> targetConnectors = new ArrayList<IConnector>();
        ArrayList attachedConnections = new ArrayList();
        attachedConnections.addAll(nextTargetConnector.getOutgoing());
        attachedConnections.addAll(nextTargetConnector.getIncoming());
        for (IConnection connToTarget : attachedConnections) {
            IConnector connectorTgt = null;
            IConnector connectorSrc = null;
            if (connToTarget.getTarget().getOwner() != nextTargetConnector.getOwner()) {
                connectorTgt = connToTarget.getTarget();
                connectorSrc = connToTarget.getSource();
            }
            if (connToTarget.getSource().getOwner() != nextTargetConnector.getOwner()) {
                connectorTgt = connToTarget.getSource();
                connectorSrc = connToTarget.getTarget();
            }
            if (connectorTgt == null || connectorSrc == null) {
                throw new RuntimeException("Error: \"floating\" connection found during transformation for the DSE.");
            }
            IHierarchicElement tgtElement = connectorTgt.getOwner();
            if (visitedTargetConnectors.contains(connectorTgt) || tgtElement == sourceConnector.getOwner()) continue;
            if (tgtElement instanceof IPlatformArchitectureElement && RouteUtils.isValidConnectionTarget((IPlatformArchitectureElement)tgtElement, executionUnits)) {
                targetConnectors.add(connectorTgt);
                continue;
            }
            if (tgtElement == connectorSrc.getOwner().getContainer() && !(nextTargetConnector instanceof IPlatformExport)) {
                IConnector currTgtConnector;
                for (IConnection currConn : connectorTgt.getOutgoing()) {
                    currTgtConnector = currConn.getTarget();
                    if (currTgtConnector.getOwner().getContainer() == tgtElement) continue;
                    if (tgtElement instanceof IPlatformArchitectureElement && RouteUtils.isValidConnectionTarget((IPlatformArchitectureElement)currTgtConnector.getOwner(), executionUnits)) {
                        targetConnectors.add(currTgtConnector);
                        continue;
                    }
                    possibleTargetConnectors.add(currTgtConnector);
                }
                for (IConnection currConn : connectorTgt.getIncoming()) {
                    currTgtConnector = currConn.getSource();
                    if (currTgtConnector.getOwner().getContainer() == tgtElement) continue;
                    if (tgtElement instanceof IPlatformArchitectureElement && RouteUtils.isValidConnectionTarget((IPlatformArchitectureElement)currTgtConnector.getOwner(), executionUnits)) {
                        targetConnectors.add(currTgtConnector);
                        continue;
                    }
                    possibleTargetConnectors.add(currTgtConnector);
                }
                visitedTargetConnectors.add(connectorTgt);
                continue;
            }
            possibleTargetConnectors.add(connectorTgt);
        }
        return targetConnectors;
    }

    private static boolean isValidConnectionTarget(IPlatformArchitectureElement element, Collection<ExecutionUnit> executionUnits) {
        if (element instanceof IPlatformResource && executionUnits.contains(element)) {
            return true;
        }
        return element instanceof IPlatformCommunicationResource && element.getContainedElements().isEmpty();
    }

    private static void determineNextConnectionTargets(LinkedList<IConnector> execUnitConnectors, Collection<IConnector> visitedConnectors, Collection<IHierarchicElement> targetElements, Collection<ExecutionUnit> executionUnits) {
        for (IHierarchicElement targetElement : targetElements) {
            if (!(targetElement instanceof IPlatformResource) || executionUnits.contains(targetElement)) continue;
            for (IConnector connectorAtTarget : targetElement.getConnectors()) {
                if (connectorAtTarget == targetElement || visitedConnectors.contains(connectorAtTarget)) continue;
                execUnitConnectors.add(connectorAtTarget);
            }
        }
    }

    public static boolean busUsesRoute(TransmissionUnit tu, Route route) {
        for (Segment segment : route.getAllSegments()) {
            if (segment.getEntity() != tu) continue;
            return true;
        }
        return false;
    }

    public static Collection<Route> getRoutes(Collection<Route> routes, IPlatformResource sourceECU, IPlatformResource targetECU) {
        HashSet<Route> matchingRoutes = new HashSet<Route>();
        for (Route route : routes) {
            if (route.getRootSegment().getEntity() != sourceECU) continue;
            for (Segment segment : route.getAllSegments()) {
                if (segment.getEntity() != targetECU || !segment.getNext().isEmpty()) continue;
                matchingRoutes.add(route);
            }
        }
        return matchingRoutes;
    }
}

