/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.hierarchic.compose.base.PlatformElementCompositorBase;
import org.fortiss.af3.platform.hierarchic.compose.elements.ClusterCompositor;
import org.fortiss.af3.platform.hierarchic.model.cluster.Cluster;
import org.fortiss.af3.platform.hierarchic.model.cluster.OffChipNetworkGateway;
import org.fortiss.af3.platform.hierarchic.model.node.OffChipNetworkPort;
import org.fortiss.af3.platform.model.PlatformArchitecture;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;

public class HierarchicPlatformArchitectureCompositor
extends PlatformElementCompositorBase<PlatformArchitecture> {
    private static List<Class<? extends EObject>> CLUSTER_LEVEL_ELEMENTS = Arrays.asList(Cluster.class, OffChipNetworkGateway.class);
    private boolean isClusterLevel = false;
    private boolean isNodeLevel = false;

    @Override
    public List<Class<? extends EObject>> getChildElementTypes() {
        ArrayList<Class<? extends EObject>> types = new ArrayList<Class<? extends EObject>>();
        if (!this.isNodeLevel) {
            types.addAll(CLUSTER_LEVEL_ELEMENTS);
        }
        if (!this.isClusterLevel) {
            types.addAll(ClusterCompositor.NODE_LEVEL_ELEMENTS);
            types.remove(OffChipNetworkPort.class);
        }
        return types;
    }

    @Override
    public boolean canCompose(PlatformArchitecture container, EObject contained, IElementCompositionContext context) {
        for (IHierarchicElement element : container.getContainedElements()) {
            if (LambdaUtils.isAssignableFromAny(CLUSTER_LEVEL_ELEMENTS, element.getClass())) {
                this.isClusterLevel = true;
                break;
            }
            if (!LambdaUtils.isAssignableFromAny(ClusterCompositor.NODE_LEVEL_ELEMENTS, element.getClass())) continue;
            this.isNodeLevel = true;
            break;
        }
        boolean rval = super.canCompose(container, contained, context);
        this.isClusterLevel = false;
        this.isNodeLevel = false;
        return rval;
    }
}

