/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.fortiss.af3.platform.hierarchic.compose.base.IPlatformHierarchicalCompositionRules;
import org.fortiss.af3.platform.hierarchic.compose.base.PlatformHierarchicalCompositionRulesBase;
import org.fortiss.af3.platform.hierarchic.model.cluster.IClusterDomain;
import org.fortiss.af3.platform.hierarchic.model.electronics.IElectronicsDomain;
import org.fortiss.af3.platform.hierarchic.model.memory.IMemoryDomain;
import org.fortiss.af3.platform.hierarchic.model.noc.INocDomain;
import org.fortiss.af3.platform.hierarchic.model.node.INodeDomain;
import org.fortiss.af3.platform.hierarchic.model.node.OffChipNetwork;
import org.fortiss.af3.platform.hierarchic.model.offchipnetwork.IOffChipNetworkDomain;
import org.fortiss.af3.platform.hierarchic.model.peripherals.IPeripheralsDomain;
import org.fortiss.af3.platform.hierarchic.model.processor.IProcessorDomain;
import org.fortiss.af3.platform.hierarchic.model.tile.ITileDomain;
import org.fortiss.af3.platform.hierarchic.model.tile.OnChipNetwork;
import org.fortiss.af3.platform.hierarchic.model.tile.Tile;
import org.fortiss.af3.platform.model.IArchitectureDomain;
import org.fortiss.af3.platform.model.IPlatformDomain;

public class HierarchicalCompositionRules
extends PlatformHierarchicalCompositionRulesBase {
    public static IPlatformHierarchicalCompositionRules INSTANCE = new HierarchicalCompositionRules();

    @Override
    public EList<Class<? extends IArchitectureDomain>> getAdmissibleChildDomains(Class<? extends IArchitectureDomain> domain) {
        BasicEList rval = new BasicEList();
        if (domain.equals(OffChipNetwork.class)) {
            rval.add(IOffChipNetworkDomain.class);
        } else if (domain.equals(Tile.class)) {
            rval.add(IProcessorDomain.class);
            rval.add(IMemoryDomain.class);
        } else if (domain.equals(OnChipNetwork.class)) {
            rval.add(INocDomain.class);
        } else if (this.hasEqualLevel(domain, IPlatformDomain.class)) {
            rval.add(IClusterDomain.class);
            rval.add(INodeDomain.class);
            rval.add(IElectronicsDomain.class);
        } else if (this.hasEqualLevel(domain, IClusterDomain.class)) {
            rval.add(INodeDomain.class);
            rval.add(IElectronicsDomain.class);
        } else if (this.hasEqualLevel(domain, INodeDomain.class)) {
            rval.add(ITileDomain.class);
            rval.add(IOffChipNetworkDomain.class);
            rval.add(IMemoryDomain.class);
            rval.add(IElectronicsDomain.class);
            rval.add(IPeripheralsDomain.class);
        } else if (this.hasEqualLevel(domain, ITileDomain.class)) {
            rval.add(IProcessorDomain.class);
            rval.add(IMemoryDomain.class);
            rval.add(INocDomain.class);
            rval.add(IElectronicsDomain.class);
            rval.add(IPeripheralsDomain.class);
        } else if (this.hasEqualLevel(domain, IMemoryDomain.class)) {
            rval.add(IProcessorDomain.class);
            rval.add(ITileDomain.class);
            rval.add(IElectronicsDomain.class);
        } else if (this.hasEqualLevel(domain, IPeripheralsDomain.class)) {
            rval.add(IElectronicsDomain.class);
        }
        return rval;
    }

    private boolean isCompatibleDomainsCommutative(Class<? extends IArchitectureDomain> domain1, Class<? extends IArchitectureDomain> domain2, Class<? extends IArchitectureDomain> domain1Ref, Class<? extends IArchitectureDomain> domain2Ref) {
        return domain1Ref.isAssignableFrom(domain1) && domain2Ref.isAssignableFrom(domain2) || domain1Ref.isAssignableFrom(domain2) && domain2Ref.isAssignableFrom(domain1);
    }

    @Override
    public boolean isCompatibleDomains(Class<? extends IArchitectureDomain> domain1, Class<? extends IArchitectureDomain> domain2) {
        boolean electricalSupply;
        boolean processorAndMemory = this.isCompatibleDomainsCommutative(domain1, domain2, IProcessorDomain.class, IMemoryDomain.class);
        boolean tileAndPeripherals = this.isCompatibleDomainsCommutative(domain1, domain2, ITileDomain.class, IPeripheralsDomain.class);
        boolean tileAndElectrialSupply = this.isCompatibleDomainsCommutative(domain1, domain2, ITileDomain.class, IElectronicsDomain.class);
        boolean nodeAndElectrialSupply = this.isCompatibleDomainsCommutative(domain1, domain2, INodeDomain.class, IElectronicsDomain.class);
        boolean clusterAndElectrialSupply = this.isCompatibleDomainsCommutative(domain1, domain2, IClusterDomain.class, IElectronicsDomain.class);
        boolean memoryAndElectrialSupply = this.isCompatibleDomainsCommutative(domain1, domain2, IMemoryDomain.class, IElectronicsDomain.class);
        boolean peripheralsAndElectrialSupply = this.isCompatibleDomainsCommutative(domain1, domain2, IPeripheralsDomain.class, IElectronicsDomain.class);
        boolean bl = electricalSupply = tileAndElectrialSupply || nodeAndElectrialSupply || clusterAndElectrialSupply || memoryAndElectrialSupply || peripheralsAndElectrialSupply;
        return tileAndPeripherals || processorAndMemory || electricalSupply || super.isCompatibleDomains(domain1, domain2);
    }
}

