/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose.base;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.model.ICommunicationRole;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.platform.utils.PlatformModelElementFactory;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.IConnectionCompositor;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public abstract class ConnectionCompositorBase<S extends PlatformConnectorUnit, T extends PlatformConnectorUnit>
implements IConnectionCompositor<IHierarchicElement, S, T> {
    private S source;
    private T target;

    protected void updateSourceTarget(S source, T target) {
        this.source = source;
        this.target = target;
    }

    protected S getSource() {
        return this.source;
    }

    protected T getTarget() {
        return this.target;
    }

    protected abstract boolean singleConnectionSource();

    protected abstract boolean singleConnectionTarget();

    private boolean haveCommonGrandParentElement(IConnector source, IConnector target) {
        IHierarchicElement sourceElement = source.getOwner();
        IHierarchicElement targetElement = target.getOwner();
        if (sourceElement == null || targetElement == null) {
            return false;
        }
        return sourceElement.eContainer() == targetElement.eContainer();
    }

    public boolean canConnect(S source, T target, IHierarchicElement parent, IConnectionCompositionContext context) {
        Class commRole = PlatformArchitectureUtils.getCommunicationRole(source, target);
        if (commRole != null && commRole.equals(ICommunicationRole.class)) {
            return false;
        }
        BasicEList incoming = new BasicEList();
        BasicEList outgoing = new BasicEList();
        if (this.swap()) {
            for (IConnection c : source.getIncoming()) {
                if (!this.haveCommonGrandParentElement(c.getSource(), (IConnector)source)) continue;
                incoming.add((Object)c);
            }
            for (IConnection c : target.getOutgoing()) {
                if (!this.haveCommonGrandParentElement(c.getTarget(), (IConnector)target)) continue;
                outgoing.add((Object)c);
            }
            return !(!incoming.isEmpty() && this.singleConnectionSource() || !outgoing.isEmpty() && this.singleConnectionTarget());
        }
        for (IConnection c : source.getOutgoing()) {
            if (!this.haveCommonGrandParentElement(c.getTarget(), (IConnector)source)) continue;
            outgoing.add((Object)c);
        }
        for (IConnection c : target.getIncoming()) {
            if (!this.haveCommonGrandParentElement(c.getSource(), (IConnector)target)) continue;
            incoming.add((Object)c);
        }
        return !(!outgoing.isEmpty() && this.singleConnectionSource() || !incoming.isEmpty() && this.singleConnectionTarget());
    }

    protected abstract boolean swap();

    public boolean connect(S source, T target, IHierarchicElement parent, IConnectionCompositionContext context) {
        this.updateSourceTarget(source, target);
        TransmissionConnection link = PlatformModelElementFactory.createTransmissionConnection();
        ITopLevelElement topLevelElement = IPersistencyService.getInstance().getTopLevelElementFor(source);
        topLevelElement.prepareIDs((EObject)link);
        parent.getConnections().add((Object)link);
        if (this.swap()) {
            link.setSource(target);
            link.setTarget(source);
        } else {
            link.setSource(source);
            link.setTarget(target);
        }
        this.updateSourceTarget(null, null);
        return true;
    }

    public boolean canReconnect(EObject connection, S source, T target, IConnectionCompositionContext context) {
        return false;
    }

    public boolean reconnect(EObject connection, S source, T target, IConnectionCompositionContext context) {
        return false;
    }

    public boolean canDisconnect(EObject connection) {
        if (connection instanceof TransmissionConnection) {
            TransmissionConnection c = (TransmissionConnection)connection;
            return c.getSource() != null && c.getTarget() != null;
        }
        return false;
    }

    public boolean disconnect(EObject connection) {
        if (connection instanceof TransmissionConnection) {
            TransmissionConnection link = (TransmissionConnection)connection;
            link.setOwner(null);
            link.setSource(null);
            link.setTarget(null);
            return true;
        }
        return false;
    }
}

