/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose.base;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.tooling.base.compose.HierarchicElementCompositorBase;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.RectangleLayoutUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.Prototype;
import org.fortiss.tooling.kernel.service.IPrototypeService;

public abstract class PlatformElementCompositorBase<T extends IHierarchicElement>
extends HierarchicElementCompositorBase<T> {
    private static boolean isInRecursion = false;

    public abstract List<Class<? extends EObject>> getChildElementTypes();

    public boolean canCompose(T container, EObject contained, IElementCompositionContext context) {
        return LambdaUtils.isAssignableFromAny(this.getChildElementTypes(), contained.getClass());
    }

    public boolean canComposePrototype(Prototype prototype) {
        Class<?> clazz = prototype.getPrototype().getClass();
        if (LambdaUtils.isAssignableFromAny(this.getChildElementTypes(), clazz)) {
            return true;
        }
        if (!IConnector.class.isAssignableFrom(clazz) || isInRecursion) {
            return false;
        }
        isInRecursion = true;
        IPrototypeService ps = IPrototypeService.getInstance();
        for (Class<EObject> childClazz : this.getChildElementTypes()) {
            for (Prototype childComposablePrototype : ps.getComposablePrototypes(childClazz)) {
                if (!clazz.isAssignableFrom(childComposablePrototype.getPrototype().getClass())) continue;
                isInRecursion = false;
                return true;
            }
        }
        isInRecursion = false;
        return false;
    }

    public boolean canDecompose(EObject contained) {
        return true;
    }

    public boolean compose(T container, EObject contained, IElementCompositionContext context) {
        super.compose(container, contained, context);
        if (PlatformArchitectureUtils.isPlatformConnector((EObject)contained)) {
            PlatformConnectorUnit cunit = (PlatformConnectorUnit)contained;
            if (context instanceof ElementDropContext) {
                ElementDropContext ctx = (ElementDropContext)context;
                if (ctx.isRoot()) {
                    int size = 12;
                    RectangleLayoutUtils.layoutNodeInRoot((ILayoutedModelElement)cunit, (ElementDropContext)ctx, (int)size, (boolean)true);
                } else if (container instanceof ILayoutedModelElement) {
                    RectangleLayoutUtils.layoutConnectorInRectangle((ILayoutedModelElement)cunit, (ILayoutedModelElement)((ILayoutedModelElement)container), (Point)ctx.getPosition());
                } else assert (false);
            }
            container.getConnectors().add((Object)cunit);
            return true;
        }
        if (PlatformArchitectureUtils.isPlatformElement((EObject)contained)) {
            LayoutDataUtils.layoutModelElement((EObject)contained, (IElementCompositionContext)context);
            container.getContainedElements().add((Object)((IHierarchicElement)contained));
            return true;
        }
        return false;
    }
}

