/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose.base;

import org.conqat.lib.commons.reflect.ReflectionUtils;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.hierarchic.compose.base.IArchitectureDomainDependant;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.IArchitectureDomain;
import org.fortiss.af3.platform.model.ICommunicationRole;
import org.fortiss.af3.platform.model.MemoryUnit;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.utils.PlatformArchitectureUtils;
import org.fortiss.af3.platform.utils.PlatformModelElementFactory;
import org.fortiss.tooling.base.compose.HierarchicElementConnectionCompositorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public abstract class PlatformElementConnectionCompositorBase<S extends IArchitectureDomain & IHierarchicElement, T extends IArchitectureDomain & IHierarchicElement>
extends HierarchicElementConnectionCompositorBase<IHierarchicElement, S, T>
implements IArchitectureDomainDependant {
    private S source;
    private T target;

    private void updateSourceTarget(S source, T target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public Class<? extends IArchitectureDomain> getArchitectureDomain() {
        assert (this.getPlatformCompositionRules().hasEqualLevel(this.source.getClass(), this.target.getClass()));
        return this.source.getClass();
    }

    protected Class<? extends ICommunicationRole> getCommunicationRole() {
        return PlatformArchitectureUtils.getCommunicationRole(this.source, this.target);
    }

    protected boolean swap(S source, T target) {
        return source instanceof TransmissionUnit && !(target instanceof TransmissionUnit);
    }

    public boolean connect(S source, T target, IHierarchicElement parent, IConnectionCompositionContext context) {
        IConnector targetConnector;
        IConnector sourceConnector;
        assert (this.getPlatformCompositionRules().hasEqualLevel(source.getClass(), target.getClass()));
        this.updateSourceTarget(source, target);
        if (this.swap(source, target)) {
            sourceConnector = this.createExitConnector();
            targetConnector = this.createEntryConnector();
        } else {
            sourceConnector = this.createEntryConnector();
            targetConnector = this.createExitConnector();
        }
        this.avoidDuplicateConnectorName((IHierarchicElement)source, sourceConnector);
        this.avoidDuplicateConnectorName((IHierarchicElement)target, targetConnector);
        this.createNewSourceDropContext((IHierarchicElement)source, context, (EObject)sourceConnector);
        this.createNewTargetDropContext((IHierarchicElement)target, context, (EObject)targetConnector);
        ITopLevelElement topElement = IPersistencyService.getInstance().getTopLevelElementFor((EObject)parent);
        this.createConnection(sourceConnector, targetConnector, parent, topElement);
        this.updateSourceTarget(null, null);
        return true;
    }

    private boolean isPrimaryPlatformElement(Object element) {
        return ReflectionUtils.isInstanceOfAny((Object)element, (Class[])new Class[]{ExecutionUnit.class, GatewayUnit.class, MemoryUnit.class});
    }

    public boolean canConnect(S source, T target, IHierarchicElement parent, IConnectionCompositionContext context) {
        if (source.eContainer() != target.eContainer()) {
            return false;
        }
        if (!(source instanceof TransmissionUnit && this.isPrimaryPlatformElement(target) || target instanceof TransmissionUnit && this.isPrimaryPlatformElement(source))) {
            return false;
        }
        return super.canConnect(source, target, parent, context);
    }

    protected IConnection createConnection() {
        return PlatformModelElementFactory.createTransmissionConnection();
    }
}

