/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose.base;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.fortiss.af3.platform.hierarchic.compose.base.IPlatformHierarchicalCompositionRules;
import org.fortiss.af3.platform.model.IArchitectureDomain;

public abstract class PlatformHierarchicalCompositionRulesBase
implements IPlatformHierarchicalCompositionRules {
    protected Set<Class<?>> getClassesBfs(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        nextLevel.add(clazz);
        do {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                Class<?>[] classArray = each.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> eachInt = classArray[n2];
                    nextLevel.add(eachInt);
                    ++n2;
                }
            }
        } while (!nextLevel.isEmpty());
        return classes;
    }

    protected List<Class<?>> commonSuperClasses(Class<?> ... classes) {
        LinkedHashSet<Object> rollingIntersect = classes.length != 0 ? new LinkedHashSet(this.getClassesBfs(classes[0])) : new LinkedHashSet();
        int i = 1;
        while (i < classes.length) {
            rollingIntersect.retainAll(this.getClassesBfs(classes[i]));
            ++i;
        }
        return new LinkedList(rollingIntersect);
    }

    @Override
    public boolean isValidContainer(Class<? extends IArchitectureDomain> container, Class<? extends IArchitectureDomain> contained) {
        for (Class childDomain : this.getAdmissibleChildDomains(container)) {
            if (!this.hasEqualLevel(childDomain, contained)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasEqualLevel(Class<? extends IArchitectureDomain> domain1, Class<? extends IArchitectureDomain> domain2) {
        List<Class<?>> commonSuperClasses = this.commonSuperClasses(domain1, domain2);
        for (Class<?> c : commonSuperClasses) {
            if (!IArchitectureDomain.class.isAssignableFrom(c) || c.equals(IArchitectureDomain.class)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    protected final boolean anyHasEqualLevel(Class<? extends IArchitectureDomain> refDomain, Class<? extends IArchitectureDomain> ... domains) {
        Class<? extends IArchitectureDomain>[] classArray = domains;
        int n = domains.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IArchitectureDomain> domain = classArray[n2];
            if (this.hasEqualLevel(refDomain, domain)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isCompatibleDomains(Class<? extends IArchitectureDomain> domain1, Class<? extends IArchitectureDomain> domain2) {
        return this.hasEqualLevel(domain1, domain2);
    }
}

