/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.compose.connections;

import org.fortiss.af3.platform.hierarchic.compose.HierarchicalCompositionRules;
import org.fortiss.af3.platform.hierarchic.compose.base.GenericPlatformSourceTargetConnectorConnectionCompositorBase;
import org.fortiss.af3.platform.hierarchic.compose.base.IPlatformHierarchicalCompositionRules;
import org.fortiss.af3.platform.hierarchic.model.electronics.ClockIn;
import org.fortiss.af3.platform.hierarchic.model.electronics.ClockOut;
import org.fortiss.af3.platform.hierarchic.model.electronics.PowerIn;
import org.fortiss.af3.platform.hierarchic.model.electronics.PowerOut;
import org.fortiss.af3.platform.hierarchic.model.peripherals.WatchDogIn;
import org.fortiss.af3.platform.hierarchic.model.peripherals.WatchDogOut;
import org.fortiss.af3.platform.model.IArchitectureDomain;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;

public class ClockPowerWatchDogConnectionCompositor<S extends PlatformConnectorUnit & IArchitectureDomain, T extends PlatformConnectorUnit & IArchitectureDomain>
extends GenericPlatformSourceTargetConnectorConnectionCompositorBase<S, T> {
    @Override
    public IPlatformHierarchicalCompositionRules getPlatformCompositionRules() {
        return HierarchicalCompositionRules.INSTANCE;
    }

    @Override
    public boolean canConnect(S source, T target, IHierarchicElement parent, IConnectionCompositionContext context) {
        boolean isValidCrossLayerConnection;
        boolean portsSameLayer = source.eContainer().eContainer() == target.eContainer().eContainer();
        boolean sourceHasSameLayerConnection = source.getIncoming().stream().anyMatch(c -> this.isSameLayer((IConnection)c, parent)) || source.getOutgoing().stream().anyMatch(c -> this.isSameLayer((IConnection)c, parent));
        boolean targetHasSameLayerConnection = target.getIncoming().stream().anyMatch(c -> this.isSameLayer((IConnection)c, parent)) || target.getOutgoing().stream().anyMatch(c -> this.isSameLayer((IConnection)c, parent));
        boolean sourceInputHasSameLayerConnection = (source instanceof PowerIn || source instanceof ClockIn || source instanceof WatchDogIn) && sourceHasSameLayerConnection;
        boolean targetInputHasSameLayerConnection = (target instanceof PowerIn || target instanceof ClockIn || target instanceof WatchDogIn) && targetHasSameLayerConnection;
        boolean powerInToOutConnection = source instanceof PowerIn && target instanceof PowerOut || source instanceof PowerOut && target instanceof PowerIn;
        boolean clockInToOutConnection = source instanceof ClockIn && target instanceof ClockOut || source instanceof ClockOut && target instanceof ClockIn;
        boolean watchDogInToOutConnection = source instanceof WatchDogIn && target instanceof WatchDogOut || source instanceof WatchDogOut && target instanceof WatchDogIn;
        boolean validSameLayerConnectorTypes = portsSameLayer && (powerInToOutConnection || clockInToOutConnection || watchDogInToOutConnection);
        boolean isSameLayerInputUnconnected = !sourceInputHasSameLayerConnection && !targetInputHasSameLayerConnection;
        boolean isValidSameLayerConnection = portsSameLayer && validSameLayerConnectorTypes && isSameLayerInputUnconnected;
        boolean sourceIsInput = source instanceof PowerIn || source instanceof ClockIn || source instanceof WatchDogIn;
        boolean targetIsInput = target instanceof PowerIn || target instanceof ClockIn || target instanceof WatchDogIn;
        boolean validUpperLayerTypes = !portsSameLayer && sourceIsInput && targetIsInput;
        boolean sourceIsUpperLayer = source.eContainer() == target.eContainer().eContainer();
        boolean targetIsUpperLayer = target.eContainer() == source.eContainer().eContainer();
        boolean isValidCrossLayerConnectionCount = targetIsUpperLayer && !sourceInputHasSameLayerConnection || sourceIsUpperLayer && !targetInputHasSameLayerConnection;
        boolean bl = isValidCrossLayerConnection = validUpperLayerTypes && isValidCrossLayerConnectionCount;
        return isValidSameLayerConnection || isValidCrossLayerConnection;
    }

    private boolean isSameLayer(IConnection connection, IHierarchicElement parent) {
        return connection.getOwner() == parent;
    }

    @Override
    public Class<? extends IArchitectureDomain> getArchitectureDomain() {
        return null;
    }
}

