/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.consistency;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.consistency.provider.AF3ConsistencyProviderBase;
import org.fortiss.af3.platform.hierarchic.model.node.Node;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.annotation.FlashSize;
import org.fortiss.af3.platform.model.annotation.HardwareCost;
import org.fortiss.af3.platform.model.annotation.RamSize;
import org.fortiss.consistency.model.views.ClassFeature;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElement;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsFactory;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage;
import org.fortiss.consistency.viewtypes.architectureElements.Connector;
import org.fortiss.consistency.viewtypes.architectureElements.InputConnector;
import org.fortiss.consistency.viewtypes.architectureElements.OutputConnector;
import org.fortiss.consistency.viewtypes.architectureElements.PlatformExecutionElement;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class NodeConsistencyProvider
extends AF3ConsistencyProviderBase<Node> {
    public Class<?> getClassOfCorrespondingConsistencyViewtypeElement() {
        return PlatformExecutionElement.class;
    }

    public EObject transformIntoConsistencyViewtypeElement(Node element, EMap<String, EList<ClassFeature>> featuresPerClass) {
        PlatformExecutionElement transformedElement = ArchitectureElementsFactory.eINSTANCE.createPlatformExecutionElement();
        IConsistencyProviderService consistencyService = IConsistencyProviderService.getInstance();
        List neededFeatureNames = super.getFeatureNamesForCurrentClass(featuresPerClass);
        super.transformBasicInformation((EObject)element, (EObject)transformedElement, neededFeatureNames);
        super.transformContainedElements((IHierarchicElementContainer)element, (ArchitectureElement)transformedElement, featuresPerClass);
        EList specs = element.getSpecifications();
        EAttribute currentFeature = ArchitectureElementsPackage.Literals.PLATFORM_EXECUTION_ELEMENT__ACQUISITION_COST;
        if (neededFeatureNames.contains(currentFeature.getName())) {
            double acquisitionCost = 0.0;
            EList costSpec = EcoreUtils.pickInstanceOf(HardwareCost.class, (List)specs);
            if (costSpec != null && !costSpec.isEmpty()) {
                acquisitionCost = ((HardwareCost)costSpec.iterator().next()).getCost();
            }
            transformedElement.setAcquisitionCost(acquisitionCost);
        }
        if (neededFeatureNames.contains((currentFeature = ArchitectureElementsPackage.Literals.PLATFORM_EXECUTION_ELEMENT__PROVIDED_FLASH_MEMORY).getName())) {
            double providedFlashMemory = 0.0;
            EList flashSpec = EcoreUtils.pickInstanceOf(FlashSize.class, (List)specs);
            if (flashSpec != null && !flashSpec.isEmpty()) {
                providedFlashMemory = ((FlashSize)flashSpec.iterator().next()).getBytes();
            }
            transformedElement.setProvidedFlashMemory(providedFlashMemory);
        }
        if (neededFeatureNames.contains(currentFeature.getName())) {
            currentFeature = ArchitectureElementsPackage.Literals.PLATFORM_EXECUTION_ELEMENT__PROVIDED_RAM_MEMORY;
            double providedRamMemory = 0.0;
            EList ramSpec = EcoreUtils.pickInstanceOf(RamSize.class, (List)specs);
            if (ramSpec != null && !ramSpec.isEmpty()) {
                providedRamMemory = ((RamSize)ramSpec.iterator().next()).getBytes();
            }
            transformedElement.setProvidedRamMemory(providedRamMemory);
        }
        EList connectors = element.getConnectors();
        for (IConnector connector : connectors) {
            EObject transformedConnector;
            currentFeature = ArchitectureElementsPackage.Literals.ARCHITECTURE_ELEMENT__INPUT_CONNECTORS;
            if (neededFeatureNames.contains(currentFeature.getName()) && connector instanceof EntryConnectorBase && (transformedConnector = consistencyService.transformIntoConsistencyViewtypeElement((EObject)connector, featuresPerClass)) instanceof InputConnector) {
                transformedElement.getInputConnectors().add((Object)((InputConnector)transformedElement));
            }
            if (neededFeatureNames.contains((currentFeature = ArchitectureElementsPackage.Literals.ARCHITECTURE_ELEMENT__OUTPUT_CONNECTORS).getName()) && connector instanceof ExitConnectorBase && (transformedConnector = consistencyService.transformIntoConsistencyViewtypeElement((EObject)connector, featuresPerClass)) instanceof OutputConnector) {
                transformedElement.getOutputConnectors().add((Object)((OutputConnector)transformedElement));
            }
            if (!neededFeatureNames.contains((currentFeature = ArchitectureElementsPackage.Literals.ARCHITECTURE_ELEMENT__BIDIRECTIONAL_CONNECTORS).getName()) || !(connector instanceof PlatformConnectorUnit) || !((transformedConnector = consistencyService.transformIntoConsistencyViewtypeElement((EObject)connector, featuresPerClass)) instanceof Connector)) continue;
            transformedElement.getBidirectionalConnectors().add((Object)((Connector)transformedConnector));
        }
        return transformedElement;
    }
}

