/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.utils;

import org.fortiss.af3.platform.hierarchic.compose.HierarchicalCompositionRules;
import org.fortiss.af3.platform.hierarchic.model.cluster.Cluster;
import org.fortiss.af3.platform.hierarchic.model.cluster.ClusterFactory;
import org.fortiss.af3.platform.hierarchic.model.cluster.IClusterDomain;
import org.fortiss.af3.platform.hierarchic.model.cluster.OffChipNetworkGateway;
import org.fortiss.af3.platform.hierarchic.model.electronics.Clock;
import org.fortiss.af3.platform.hierarchic.model.electronics.ClockIn;
import org.fortiss.af3.platform.hierarchic.model.electronics.ClockOut;
import org.fortiss.af3.platform.hierarchic.model.electronics.ElectronicsFactory;
import org.fortiss.af3.platform.hierarchic.model.electronics.PowerIn;
import org.fortiss.af3.platform.hierarchic.model.electronics.PowerOut;
import org.fortiss.af3.platform.hierarchic.model.electronics.PowerSupply;
import org.fortiss.af3.platform.hierarchic.model.memory.Cache;
import org.fortiss.af3.platform.hierarchic.model.memory.CacheIn;
import org.fortiss.af3.platform.hierarchic.model.memory.CacheOut;
import org.fortiss.af3.platform.hierarchic.model.memory.MemoryFactory;
import org.fortiss.af3.platform.hierarchic.model.memory.RAM;
import org.fortiss.af3.platform.hierarchic.model.memory.ROM;
import org.fortiss.af3.platform.hierarchic.model.noc.INocDomain;
import org.fortiss.af3.platform.hierarchic.model.noc.NocFactory;
import org.fortiss.af3.platform.hierarchic.model.noc.NocInputUnit;
import org.fortiss.af3.platform.hierarchic.model.noc.NocOutputUnit;
import org.fortiss.af3.platform.hierarchic.model.noc.NocRouter;
import org.fortiss.af3.platform.hierarchic.model.node.INodeDomain;
import org.fortiss.af3.platform.hierarchic.model.node.Node;
import org.fortiss.af3.platform.hierarchic.model.node.NodeFactory;
import org.fortiss.af3.platform.hierarchic.model.node.OffChipNetwork;
import org.fortiss.af3.platform.hierarchic.model.node.OffChipNetworkInterface;
import org.fortiss.af3.platform.hierarchic.model.node.OffChipNetworkPort;
import org.fortiss.af3.platform.hierarchic.model.offchipnetwork.IOffChipNetworkDomain;
import org.fortiss.af3.platform.hierarchic.model.offchipnetwork.OffChipNetworkRouter;
import org.fortiss.af3.platform.hierarchic.model.offchipnetwork.OffChipNetworkRouterPort;
import org.fortiss.af3.platform.hierarchic.model.offchipnetwork.OffchipnetworkFactory;
import org.fortiss.af3.platform.hierarchic.model.peripherals.Actuator;
import org.fortiss.af3.platform.hierarchic.model.peripherals.GeneralPurposeInput;
import org.fortiss.af3.platform.hierarchic.model.peripherals.GeneralPurposeOutput;
import org.fortiss.af3.platform.hierarchic.model.peripherals.PeripheralsFactory;
import org.fortiss.af3.platform.hierarchic.model.peripherals.Sensor;
import org.fortiss.af3.platform.hierarchic.model.peripherals.WatchDog;
import org.fortiss.af3.platform.hierarchic.model.peripherals.WatchDogIn;
import org.fortiss.af3.platform.hierarchic.model.peripherals.WatchDogOut;
import org.fortiss.af3.platform.hierarchic.model.processor.Bus;
import org.fortiss.af3.platform.hierarchic.model.processor.BusMasterInterface;
import org.fortiss.af3.platform.hierarchic.model.processor.BusMasterPort;
import org.fortiss.af3.platform.hierarchic.model.processor.BusOnChipNetworkExport;
import org.fortiss.af3.platform.hierarchic.model.processor.BusSlaveInterface;
import org.fortiss.af3.platform.hierarchic.model.processor.BusSlavePort;
import org.fortiss.af3.platform.hierarchic.model.processor.Core;
import org.fortiss.af3.platform.hierarchic.model.processor.IProcessorDomain;
import org.fortiss.af3.platform.hierarchic.model.processor.NetworkInterface;
import org.fortiss.af3.platform.hierarchic.model.processor.ProcessorFactory;
import org.fortiss.af3.platform.hierarchic.model.tile.ITileDomain;
import org.fortiss.af3.platform.hierarchic.model.tile.MemoryController;
import org.fortiss.af3.platform.hierarchic.model.tile.MemoryControllerIn;
import org.fortiss.af3.platform.hierarchic.model.tile.MemoryControllerOut;
import org.fortiss.af3.platform.hierarchic.model.tile.OnChipNetwork;
import org.fortiss.af3.platform.hierarchic.model.tile.OnChipNetworkInterface;
import org.fortiss.af3.platform.hierarchic.model.tile.OnChipNetworkPort;
import org.fortiss.af3.platform.hierarchic.model.tile.OnChipOffChipExport;
import org.fortiss.af3.platform.hierarchic.model.tile.OnChipOffChipGateway;
import org.fortiss.af3.platform.hierarchic.model.tile.Tile;
import org.fortiss.af3.platform.hierarchic.model.tile.TileFactory;
import org.fortiss.af3.platform.model.IArchitectureDomain;
import org.fortiss.af3.platform.model.ICommunicationRole;
import org.fortiss.af3.platform.model.ICommunicationSlave;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.kernel.model.INamedElement;

public class HierarchicPlatformModelElementFactory {
    private HierarchicPlatformModelElementFactory() {
    }

    private static Object prepareElement(Object element, String name) {
        if (element instanceof INamedElement) {
            ((INamedElement)element).setName(name);
        }
        if (element instanceof ILayoutedModelElement) {
            if (element instanceof IHierarchicElement) {
                LayoutModelElementFactory.createNodeElementLayout((ILayoutedModelElement)((ILayoutedModelElement)element));
            } else if (element instanceof IConnector) {
                LayoutModelElementFactory.createConnectorLayout((ILayoutedModelElement)((ILayoutedModelElement)element));
            } else if (element instanceof IConnection) {
                LayoutModelElementFactory.createConnectionLayout((ILayoutedModelElement)((ILayoutedModelElement)element));
            }
        }
        return element;
    }

    public static PlatformConnectorUnit createInterface(Class<? extends IArchitectureDomain> domain, Class<? extends ICommunicationRole> communicationRole) {
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, IClusterDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOffChipNetworkInterface("OffChipNetworkInterface");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, INodeDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOffChipNetworkInterface("OffChipNetworkInterface");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, IOffChipNetworkDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOffChipNetworkRouterPort("OffChipNetworkRouterPort");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, ITileDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOnChipNetworkInterface("OnChipNetworkInterface");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, INocDomain.class)) {
            return HierarchicPlatformModelElementFactory.createNocInputUnit("NocInputUnit");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, IProcessorDomain.class)) {
            if (communicationRole != null && ICommunicationSlave.class.isAssignableFrom(communicationRole)) {
                return HierarchicPlatformModelElementFactory.createBusSlaveInterface("BusSlaveInterface");
            }
            return HierarchicPlatformModelElementFactory.createBusMasterInterface("BusMasterInterface");
        }
        return null;
    }

    public static PlatformConnectorUnit createPort(Class<? extends IArchitectureDomain> domain, Class<? extends ICommunicationRole> communicationRole) {
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, IClusterDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOffChipNetworkPort("OffChipNetworkPort");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, INodeDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOffChipNetworkPort("OffChipNetworkPort");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, IOffChipNetworkDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOffChipNetworkRouterPort("OffChipNetworkRouterPort");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, ITileDomain.class)) {
            return HierarchicPlatformModelElementFactory.createOnChipNetworkPort("OnChipNetworkPort");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, INocDomain.class)) {
            return HierarchicPlatformModelElementFactory.createNocOutputUnit("NocOutputUnit");
        }
        if (HierarchicalCompositionRules.INSTANCE.hasEqualLevel(domain, IProcessorDomain.class)) {
            if (communicationRole != null && ICommunicationSlave.class.isAssignableFrom(communicationRole)) {
                return HierarchicPlatformModelElementFactory.createBusSlavePort("BusSlavePort");
            }
            return HierarchicPlatformModelElementFactory.createBusMasterPort("BusMasterPort");
        }
        return null;
    }

    public static Cluster createCluster(String name) {
        return (Cluster)HierarchicPlatformModelElementFactory.prepareElement(ClusterFactory.eINSTANCE.createCluster(), name);
    }

    public static OffChipNetworkGateway createOffChipNetworkGateway(String name) {
        return (OffChipNetworkGateway)HierarchicPlatformModelElementFactory.prepareElement(ClusterFactory.eINSTANCE.createOffChipNetworkGateway(), name);
    }

    public static Node createNode(String name) {
        return (Node)HierarchicPlatformModelElementFactory.prepareElement(NodeFactory.eINSTANCE.createNode(), name);
    }

    public static OffChipNetworkPort createOffChipNetworkPort(String name) {
        return (OffChipNetworkPort)HierarchicPlatformModelElementFactory.prepareElement(NodeFactory.eINSTANCE.createOffChipNetworkPort(), name);
    }

    public static OffChipNetworkInterface createOffChipNetworkInterface(String name) {
        return (OffChipNetworkInterface)HierarchicPlatformModelElementFactory.prepareElement(NodeFactory.eINSTANCE.createOffChipNetworkInterface(), name);
    }

    public static OffChipNetwork createOffChipNetwork(String name) {
        return (OffChipNetwork)HierarchicPlatformModelElementFactory.prepareElement(NodeFactory.eINSTANCE.createOffChipNetwork(), name);
    }

    public static OffChipNetworkRouter createOffChipNetworkRouter(String name) {
        return (OffChipNetworkRouter)HierarchicPlatformModelElementFactory.prepareElement(OffchipnetworkFactory.eINSTANCE.createOffChipNetworkRouter(), name);
    }

    public static OffChipNetworkRouterPort createOffChipNetworkRouterPort(String name) {
        return (OffChipNetworkRouterPort)HierarchicPlatformModelElementFactory.prepareElement(OffchipnetworkFactory.eINSTANCE.createOffChipNetworkRouterPort(), name);
    }

    public static Tile createTile(String name) {
        return (Tile)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createTile(), name);
    }

    public static OnChipNetworkPort createOnChipNetworkPort(String name) {
        return (OnChipNetworkPort)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createOnChipNetworkPort(), name);
    }

    public static OnChipNetworkInterface createOnChipNetworkInterface(String name) {
        return (OnChipNetworkInterface)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createOnChipNetworkInterface(), name);
    }

    public static OnChipNetwork createOnChipNetwork(String name) {
        return (OnChipNetwork)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createOnChipNetwork(), name);
    }

    public static OnChipOffChipGateway createOnChipOffChipGateway(String name) {
        return (OnChipOffChipGateway)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createOnChipOffChipGateway(), name);
    }

    public static OnChipOffChipExport createOnChipOffChipExport(String name) {
        return (OnChipOffChipExport)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createOnChipOffChipExport(), name);
    }

    public static MemoryController createMemoryController(String name) {
        return (MemoryController)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createMemoryController(), name);
    }

    public static MemoryControllerOut createMemoryControllerOut(String name) {
        return (MemoryControllerOut)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createMemoryControllerOut(), name);
    }

    public static MemoryControllerIn createMemoryControllerIn(String name) {
        return (MemoryControllerIn)HierarchicPlatformModelElementFactory.prepareElement(TileFactory.eINSTANCE.createMemoryControllerIn(), name);
    }

    public static NocRouter createNocRouter(String name) {
        return (NocRouter)HierarchicPlatformModelElementFactory.prepareElement(NocFactory.eINSTANCE.createNocRouter(), name);
    }

    public static NocInputUnit createNocInputUnit(String name) {
        return (NocInputUnit)HierarchicPlatformModelElementFactory.prepareElement(NocFactory.eINSTANCE.createNocInputUnit(), name);
    }

    public static NocOutputUnit createNocOutputUnit(String name) {
        return (NocOutputUnit)HierarchicPlatformModelElementFactory.prepareElement(NocFactory.eINSTANCE.createNocOutputUnit(), name);
    }

    public static Core createCore(String name) {
        return (Core)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createCore(), name);
    }

    public static BusMasterPort createBusMasterPort(String name) {
        return (BusMasterPort)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createBusMasterPort(), name);
    }

    public static BusMasterInterface createBusMasterInterface(String name) {
        return (BusMasterInterface)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createBusMasterInterface(), name);
    }

    public static BusSlavePort createBusSlavePort(String name) {
        return (BusSlavePort)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createBusSlavePort(), name);
    }

    public static BusSlaveInterface createBusSlaveInterface(String name) {
        return (BusSlaveInterface)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createBusSlaveInterface(), name);
    }

    public static BusOnChipNetworkExport createBusOnChipNetworkExport(String name) {
        return (BusOnChipNetworkExport)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createBusOnChipNetworkExport(), name);
    }

    public static Bus createBus(String name) {
        return (Bus)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createBus(), name);
    }

    public static NetworkInterface createNetworkInterface(String name) {
        return (NetworkInterface)HierarchicPlatformModelElementFactory.prepareElement(ProcessorFactory.eINSTANCE.createNetworkInterface(), name);
    }

    public static RAM createRAM(String name) {
        return (RAM)HierarchicPlatformModelElementFactory.prepareElement(MemoryFactory.eINSTANCE.createRAM(), name);
    }

    public static ROM createROM(String name) {
        return (ROM)HierarchicPlatformModelElementFactory.prepareElement(MemoryFactory.eINSTANCE.createROM(), name);
    }

    public static Cache createCache(String name) {
        return (Cache)HierarchicPlatformModelElementFactory.prepareElement(MemoryFactory.eINSTANCE.createCache(), name);
    }

    public static CacheIn createCacheIn(String name) {
        return (CacheIn)HierarchicPlatformModelElementFactory.prepareElement(MemoryFactory.eINSTANCE.createCacheIn(), name);
    }

    public static CacheOut createCacheOut(String name) {
        return (CacheOut)HierarchicPlatformModelElementFactory.prepareElement(MemoryFactory.eINSTANCE.createCacheOut(), name);
    }

    public static WatchDog createWatchDog(String name) {
        return (WatchDog)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createWatchDog(), name);
    }

    public static WatchDogOut createWatchDogOut(String name) {
        return (WatchDogOut)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createWatchDogOut(), name);
    }

    public static WatchDogIn createWatchDogIn(String name) {
        return (WatchDogIn)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createWatchDogIn(), name);
    }

    public static GeneralPurposeOutput createGeneralPurposeOutput(String name) {
        return (GeneralPurposeOutput)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createGeneralPurposeOutput(), name);
    }

    public static GeneralPurposeInput createGeneralPurposeInput(String name) {
        return (GeneralPurposeInput)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createGeneralPurposeInput(), name);
    }

    public static Sensor createSensor(String name) {
        return (Sensor)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createSensor(), name);
    }

    public static Actuator createActuator(String name) {
        return (Actuator)HierarchicPlatformModelElementFactory.prepareElement(PeripheralsFactory.eINSTANCE.createActuator(), name);
    }

    public static Clock createClock(String name) {
        return (Clock)HierarchicPlatformModelElementFactory.prepareElement(ElectronicsFactory.eINSTANCE.createClock(), name);
    }

    public static ClockOut createClockOut(String name) {
        return (ClockOut)HierarchicPlatformModelElementFactory.prepareElement(ElectronicsFactory.eINSTANCE.createClockOut(), name);
    }

    public static ClockIn createClockIn(String name) {
        return (ClockIn)HierarchicPlatformModelElementFactory.prepareElement(ElectronicsFactory.eINSTANCE.createClockIn(), name);
    }

    public static PowerSupply createPowerSupply(String name) {
        return (PowerSupply)HierarchicPlatformModelElementFactory.prepareElement(ElectronicsFactory.eINSTANCE.createPowerSupply(), name);
    }

    public static PowerOut createPowerOut(String name) {
        return (PowerOut)HierarchicPlatformModelElementFactory.prepareElement(ElectronicsFactory.eINSTANCE.createPowerOut(), name);
    }

    public static PowerIn createPowerIn(String name) {
        return (PowerIn)HierarchicPlatformModelElementFactory.prepareElement(ElectronicsFactory.eINSTANCE.createPowerIn(), name);
    }
}

