# How to update the Z3 base libraries

## Getting and library binaries
* Fetch the osx & debian & win 64 binary archives from <https://github.com/Z3Prover/z3/releases>, e.g.
    * z3-4.12.2-x64-win.zip 
    * z3-4.12.2-x64-osx-10.16.zip
    * z3-4.12.2-x64-glibc-2.31.zip (for Ubuntu 20) 
* For the Windows 64 bit version, copy all `.dll` files from the `bin` folder into the `x64` folder of this plugin.
* For Linux, prepare and copy the `.so` libraries to the `x64` folder
    * Before copying, execute `patchelf --set-rpath '$ORIGIN' <path/to/libs>` in a terminal for all `.so`files.
    * You may need to install `patchelf` first.
* For MacOS, copy the `.dylib` files to the `x64` folder.
* From any of the above archives, copy the `com.microsoft.jar` file to this folder.

## Prepare for use in AF3

* In case of update renamed, added, or removed libraries, be sure to adapt the `AF3z3Activator` and the `MANIFEST.MF`
* Update the source jar to the current version (needed for the online documentation)
    * Download `z3-<version>.zip` source distribution and extract it
    * `cd z3-<version>/src/api/java`
    * `mkdir -p com/microsoft/z3`
    * `mv *.java com/microsoft/z3`
    * `jar cf com.microsoft.z3-src.jar com`
    * Copy `com.microsoft.z3-src.jar` to this folder