#include <string.h>
#include <stdio.h>

#if __GNUC__ >= 4
#pragma GCC visibility push(default)
#endif

#include <FMI2/fmi2Functions.h>

#ifndef FMI2_Export
#define FMI2_Export DllExport
#endif

PLACEHOLDER_TOP_INCLUDE

PLACEHOLDER_STEP_DURATION

#define BUFFER 1024

PLACEHOLDER_GUID

	typedef struct {
		fmi2Boolean loggingOn;
		char instanceName[BUFFER];
		char GUID[BUFFER];
		const fmi2CallbackFunctions* functions;

		fmi2Real lastNonExecutedDuration;

		fmi2Real fmitime;
		fmi2EventInfo eventInfo;
		char fmuLocation[BUFFER];
} component_t;

typedef component_t* component_ptr_t;

FMI2_Export const char* fmi2GetVersion(){
	return "2.0";
}

FMI2_Export fmi2Status fmi2SetDebugLogging(fmi2Component c, fmi2Boolean loggingOn, size_t n, const fmi2String cat[]){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
		comp->loggingOn = loggingOn;
		return fmi2OK;
	}
}

FMI2_Export fmi2Component fmi2Instantiate(fmi2String instanceName, fmi2Type fmuType, fmi2String fmuGUID, fmi2String fmuLocation, const fmi2CallbackFunctions* functions, fmi2Boolean visible, fmi2Boolean loggingOn){
	component_ptr_t comp;
	int k, p;

	comp = (component_ptr_t)functions->allocateMemory(1, sizeof(component_t));
	if (comp == NULL || strcmp(fmuGUID, FMI_GUID) != 0 || fmuType != fmi2CoSimulation) {
		return NULL;
	} else {	
		sprintf(comp->instanceName, "%s", instanceName);
		sprintf(comp->GUID, "%s",fmuGUID);
		comp->functions = functions;
		comp->loggingOn = loggingOn;
		/* Set default values */
PLACEHOLDER_INSTANTIATE
		comp->lastNonExecutedDuration = 0;
		sprintf(comp->fmuLocation, "%s",fmuLocation);
		return comp;
	}
}

FMI2_Export void fmi2FreeInstance(fmi2Component c){
	component_ptr_t comp = (fmi2Component)c;
	comp->functions->freeMemory(c);
}

fmi2Status standardReturn(fmi2Component c) {
	return (c == NULL) ? fmi2Fatal : fmi2OK;
}

FMI2_Export fmi2Status fmi2SetupExperiment(fmi2Component c, 
										   fmi2Boolean toleranceDefined, fmi2Real tolerance,
										   fmi2Real startTime, fmi2Boolean stopTimeDefined,
										   fmi2Real stopTime){
	component_ptr_t comp = (fmi2Component)c;
	return standardReturn(comp);
}

FMI2_Export fmi2Status fmi2EnterInitializationMode(fmi2Component c){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
PLACEHOLDER_INITIALIZATION
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2ExitInitializationMode(fmi2Component c){
	return fmi2OK;
}

FMI2_Export fmi2Status fmi2GetReal(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, fmi2Real value[]){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
		size_t k;
		for (k = 0; k < nvr; k++) {
PLACEHOLDER_GET_REAL
		}
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2GetInteger(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, fmi2Integer value[]){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
		size_t k;
		for (k = 0; k < nvr; k++) {
PLACEHOLDER_GET_INTEGER
		}
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2GetBoolean(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, fmi2Boolean value[]){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {  
		size_t k;

		for (k = 0; k < nvr; k++) {
PLACEHOLDER_GET_BOOLEAN
		}
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2GetString(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, fmi2String  value[]){
	// no string values in AutoFOCUS models
	return fmi2Fatal;
}

FMI2_Export fmi2Status fmi2SetReal(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, const fmi2Real value[]){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
		size_t k;
		for (k = 0; k < nvr; k++) {
PLACEHOLDER_SET_REAL
		}
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2SetInteger(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, const fmi2Integer value[]){
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
		size_t k;
		for (k = 0; k < nvr; k++) {
PLACEHOLDER_SET_INTEGER
		}
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2SetBoolean(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, const fmi2Boolean value[]){ 
	component_ptr_t comp = (fmi2Component)c;
	if (comp == NULL) {
		return fmi2Fatal;
	} else {
		size_t k;
		for (k = 0; k < nvr; k++) {
PLACEHOLDER_SET_BOOLEAN
		}
		return fmi2OK;
	}
}

FMI2_Export fmi2Status fmi2SetString(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, const fmi2String  value[]){
	// no string values in AutoFOCUS models
	return fmi2Fatal;
}

//
// Getting and setting the internal FMU state
//

fmi2Status fmi2GetFMUstate (fmi2Component c, fmi2FMUstate* FMUstate){
	return fmi2Error;
}

fmi2Status fmi2SetFMUstate (fmi2Component c, fmi2FMUstate  FMUstate){
	return fmi2Error;
}

fmi2Status fmi2FreeFMUstate(fmi2Component c, fmi2FMUstate* FMUstate){
	return fmi2Error;
}

fmi2Status fmi2SerializedFMUstateSize(fmi2Component c, fmi2FMUstate FMUstate,
									  size_t *size){
	return fmi2Error;
}

fmi2Status fmi2SerializeFMUstate(fmi2Component c, fmi2FMUstate FMUstate,
								 fmi2Byte serializedState[], size_t size){
	return fmi2Error;
}

fmi2Status fmi2DeSerializeFMUstate(fmi2Component c,
								   const fmi2Byte serializedState[],
								   size_t size, fmi2FMUstate* FMUstate){
	return fmi2Error;
}

//
// Getting directional derivatives
//

fmi2Status fmi2GetDirectionalDerivative(fmi2Component c,
										const fmi2ValueReference vUnknown_ref[],
										size_t nUnknown,
										const fmi2ValueReference vKnown_ref[],
										size_t nKnown,
										const fmi2Real dvKnown[],
										fmi2Real dvUnknown[]){
	return fmi2Error;
}
//*******************************
/* FMI 2.0 CS Functions */
FMI2_Export const char* fmi2GetTypesPlatform(){
	return fmi2TypesPlatform;
}

FMI2_Export fmi2Status fmi2Terminate(fmi2Component c){
	return standardReturn(c);
}

FMI2_Export fmi2Status fmi2Reset(fmi2Component c){
	return fmi2OK;
}

FMI2_Export fmi2Status fmi2SetRealInputDerivatives(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, const fmi2Integer order[], const fmi2Real value[]){
	// no real values in AutoFOCUS models
	return fmi2Fatal;
}

FMI2_Export fmi2Status fmi2GetRealOutputDerivatives(fmi2Component c, const fmi2ValueReference vr[], size_t nvr, const fmi2Integer order[], fmi2Real value[]){
	// no real values in AutoFOCUS models
	return fmi2Fatal;
}

FMI2_Export fmi2Status fmi2CancelStep(fmi2Component c){
	return fmi2OK;
}

FMI2_Export fmi2Status fmi2GetStatus(fmi2Component c, const fmi2StatusKind s, fmi2Status*  value){
	return fmi2Discard;
}

FMI2_Export fmi2Status fmi2GetRealStatus(fmi2Component c, const fmi2StatusKind s, fmi2Real*    value){
	switch (s) {
		case fmi2LastSuccessfulTime:
			/* Return the last successful time. TODO */
			*value = 0.1;
			return fmi2OK;
		default: /* Not defined for status for this function */
			return fmi2Discard;
	}
}

FMI2_Export fmi2Status fmi2GetIntegerStatus(fmi2Component c, const fmi2StatusKind s, fmi2Integer* value){
	return fmi2Discard;
}

FMI2_Export fmi2Status fmi2GetBooleanStatus(fmi2Component c, const fmi2StatusKind s, fmi2Boolean* value){
	return fmi2Discard;
}

FMI2_Export fmi2Status fmi2GetStringStatus(fmi2Component c, const fmi2StatusKind s, fmi2String*  value){
	return fmi2Discard;
}

FMI2_Export fmi2Status fmi2DoStep(fmi2Component c, fmi2Real currentCommunicationPoint, fmi2Real communicationStepSize, fmi2Boolean newStep){
	component_ptr_t comp	= (fmi2Component)c;

	if (comp == NULL) {
		return fmi2Fatal;
	} else {
PLACEHOLDER_DO_STEP_INIT_NOVAL

			if(comp->loggingOn) {
				comp->functions->logger(comp->functions->componentEnvironment, comp->instanceName, fmi2OK, "INFO", "Time elapsed since last FOCUS tick: %f", comp->lastNonExecutedDuration);
			}
			fmi2Real remainingDuration = comp->lastNonExecutedDuration + communicationStepSize;
			if(remainingDuration < STEP_DURATION_MS && comp->loggingOn) {
				comp->functions->logger(comp->functions->componentEnvironment, comp->instanceName, fmi2OK, "INFO",
					"After this cosimulation step, the time elapsed since the last tick will be: %f", remainingDuration);
				comp->functions->logger(comp->functions->componentEnvironment, comp->instanceName, fmi2OK, "INFO",
					"This is lower than the duration of a FOCUS tick (%f), therefore no FOCUS tick will be executed in this cosimulation step.", STEP_DURATION_MS);
			}
			while (remainingDuration >= STEP_DURATION_MS) {
PLACEHOLDER_PERFORM_STEP
					if(comp->loggingOn) {
						comp->functions->logger(comp->functions->componentEnvironment, comp->instanceName, fmi2OK, "INFO", "One FOCUS Tick executed");
					}
					remainingDuration = remainingDuration - STEP_DURATION_MS;
			}
			comp->lastNonExecutedDuration = remainingDuration;
			return fmi2OK;
	}
}

