model openmodelica_system
  Modelica.Blocks.Continuous.StateSpace plant(A = [0, 1; 9, 0], B = [0, 0; 9 / 10, 1], C = [1, 0], D = [0, 0], initType = Modelica.Blocks.Types.Init.InitialState, x_start = {0, 0}, y_start = {0})  annotation(
    Placement(visible = true, transformation(origin = {30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Continuous.LimPID controller(Td = 0.5, Ti = 0.5,controllerType = Modelica.Blocks.Types.SimpleController.PID, homotopyType = Modelica.Blocks.Types.LimiterHomotopy.Linear, initType = Modelica.Blocks.Types.InitPID.SteadyState, k = 50, limitsAtInit = true, wd = 1, withFeedForward = false, wp = 1, xd_start = 0, xi_start = 0, yMax = Modelica.Constants.inf, y_start = 0) annotation(
    Placement(visible = true, transformation(origin = {-30, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput angle annotation(
    Placement(visible = true, transformation(origin = {110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealOutput acceleration annotation(
    Placement(visible = true, transformation(origin = {110, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {110, -20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput setpoint annotation(
    Placement(visible = true, transformation(origin = {-110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-110, 0}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
  Modelica.Blocks.Interfaces.RealInput disturbance annotation(
    Placement(visible = true, transformation(origin = {-110, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0), iconTransformation(origin = {-110, 20}, extent = {{-10, -10}, {10, 10}}, rotation = 0)));
equation
  connect(plant.y[1], controller.u_m) annotation(
    Line(points = {{42, 0}, {60, 0}, {60, -40}, {-30, -40}, {-30, -12}}, color = {0, 0, 127}));
  connect(plant.y[1], angle) annotation(
    Line(points = {{42, 0}, {110, 0}}, color = {0, 0, 127}));
  connect(controller.y, acceleration) annotation(
    Line(points = {{-19, 0}, {-10, 0}, {-10, -20}, {110, -20}}, color = {0, 0, 127}));
  connect(controller.y, plant.u[1]) annotation(
    Line(points = {{-18, 0}, {16, 0}, {16, 0}, {18, 0}}, color = {0, 0, 127}));
  connect(setpoint, controller.u_s) annotation(
    Line(points = {{-110, 0}, {-44, 0}, {-44, 0}, {-42, 0}}, color = {0, 0, 127}));
  connect(disturbance, plant.u[2]) annotation(
    Line(points = {{-110, 20}, {0, 20}, {0, 0}, {18, 0}, {18, 0}}, color = {0, 0, 127}));
  annotation(
    uses(Modelica(version = "3.2.3")));
end openmodelica_system;
