// A method which gets the global nav bar as html string and will manipulate it 
// to fit to the given pathToTop and the executing html page.
function loadNavigationBarWithReplacements(htmlDocumentAsString, pathToTop) {
	let path = window.location.pathname;
	let pageName = path.split("/").pop();
	
	//Replacements (g for global replace)
	htmlDocumentAsString = htmlDocumentAsString.replace(/<PATH_TO_TOP>/g, pathToTop);
	htmlDocumentAsString = htmlDocumentAsString.replace(/<PAGE_NAME>/g, pageName);
	htmlDocumentAsString = htmlDocumentAsString.replace(/<PAGE_TOPIC>/g, document.title);
	
	let placeHolder = document.getElementById('navBarPlaceholder');
    if(placeHolder.outerHTML) { 
    	//if outerHTML is supported
        placeHolder.outerHTML = htmlDocumentAsString;
    } else { 
    	//if outerHTML is not supported (usually not needed anymore)
        let tmp = document.createElement("div");
        tmp.innerHTML="<!--REPLACEMENT-->";
        placeHolderParent = placeHolder.parentNode;
        placeHolderParent.replaceChild(tmp, placeHolder);
        placeHolderParent.innerHTML = placeHolderParent.innerHTML.replace('<div><!--REPLACEMENT--></div>', htmlDocumentAsString);
    }
    
    // all script for this parts must be loaded again to work
    $(function() {
	    $.getScript(pathToTop + "/layout/jsscript/submenuScript.js");
	});
}