/**
 */
package org.fortiss.consistency.viewtypes.architectureElements;

import org.eclipse.emf.common.util.EList;

import org.fortiss.consistency.viewtypes.types.SafetyLevel;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Logical Element</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.fortiss.consistency.viewtypes.architectureElements.LogicalElement#getBehavior <em>Behavior</em>}</li>
 *   <li>{@link org.fortiss.consistency.viewtypes.architectureElements.LogicalElement#getRequiredSafetyLevel <em>Required Safety Level</em>}</li>
 * </ul>
 *
 * @see org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage#getLogicalElement()
 * @model
 * @generated
 */
public interface LogicalElement extends ArchitectureElement
{
  /**
   * Returns the value of the '<em><b>Behavior</b></em>' containment reference list.
   * The list contents are of type {@link org.fortiss.consistency.viewtypes.architectureElements.BehaviorSpecification}.
   * <!-- begin-user-doc -->
   * <p>
   * If the meaning of the '<em>Behavior</em>' containment reference list isn't clear,
   * there really should be more of a description here...
   * </p>
   * <!-- end-user-doc -->
   * @return the value of the '<em>Behavior</em>' containment reference list.
   * @see org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage#getLogicalElement_Behavior()
   * @model containment="true"
   * @generated
   */
  EList<BehaviorSpecification> getBehavior();

  /**
   * Returns the value of the '<em><b>Required Safety Level</b></em>' attribute.
   * The literals are from the enumeration {@link org.fortiss.consistency.viewtypes.types.SafetyLevel}.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * <!-- begin-model-doc -->
   * RAM size in KB
   * <!-- end-model-doc -->
   * @return the value of the '<em>Required Safety Level</em>' attribute.
   * @see org.fortiss.consistency.viewtypes.types.SafetyLevel
   * @see #setRequiredSafetyLevel(SafetyLevel)
   * @see org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage#getLogicalElement_RequiredSafetyLevel()
   * @model
   * @generated
   */
  SafetyLevel getRequiredSafetyLevel();

  /**
   * Sets the value of the '{@link org.fortiss.consistency.viewtypes.architectureElements.LogicalElement#getRequiredSafetyLevel <em>Required Safety Level</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the new value of the '<em>Required Safety Level</em>' attribute.
   * @see org.fortiss.consistency.viewtypes.types.SafetyLevel
   * @see #getRequiredSafetyLevel()
   * @generated
   */
  void setRequiredSafetyLevel(SafetyLevel value);

} // LogicalElement
