/**
 */
package org.fortiss.consistency.viewtypes.architectureElements.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage;
import org.fortiss.consistency.viewtypes.architectureElements.BehaviorSpecification;
import org.fortiss.consistency.viewtypes.architectureElements.LogicalElement;

import org.fortiss.consistency.viewtypes.types.SafetyLevel;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Logical Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.fortiss.consistency.viewtypes.architectureElements.impl.LogicalElementImpl#getBehavior <em>Behavior</em>}</li>
 *   <li>{@link org.fortiss.consistency.viewtypes.architectureElements.impl.LogicalElementImpl#getRequiredSafetyLevel <em>Required Safety Level</em>}</li>
 * </ul>
 *
 * @generated
 */
public class LogicalElementImpl extends ArchitectureElementImpl implements LogicalElement
{
  /**
   * The cached value of the '{@link #getBehavior() <em>Behavior</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getBehavior()
   * @generated
   * @ordered
   */
  protected EList<BehaviorSpecification> behavior;

  /**
   * The default value of the '{@link #getRequiredSafetyLevel() <em>Required Safety Level</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getRequiredSafetyLevel()
   * @generated
   * @ordered
   */
  protected static final SafetyLevel REQUIRED_SAFETY_LEVEL_EDEFAULT = SafetyLevel.UNDEFINED;

  /**
   * The cached value of the '{@link #getRequiredSafetyLevel() <em>Required Safety Level</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getRequiredSafetyLevel()
   * @generated
   * @ordered
   */
  protected SafetyLevel requiredSafetyLevel = REQUIRED_SAFETY_LEVEL_EDEFAULT;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected LogicalElementImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  protected EClass eStaticClass()
  {
    return ArchitectureElementsPackage.Literals.LOGICAL_ELEMENT;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<BehaviorSpecification> getBehavior()
  {
    if (behavior == null)
    {
      behavior = new EObjectContainmentEList<BehaviorSpecification>(BehaviorSpecification.class, this, ArchitectureElementsPackage.LOGICAL_ELEMENT__BEHAVIOR);
    }
    return behavior;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SafetyLevel getRequiredSafetyLevel()
  {
    return requiredSafetyLevel;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setRequiredSafetyLevel(SafetyLevel newRequiredSafetyLevel)
  {
    SafetyLevel oldRequiredSafetyLevel = requiredSafetyLevel;
    requiredSafetyLevel = newRequiredSafetyLevel == null ? REQUIRED_SAFETY_LEVEL_EDEFAULT : newRequiredSafetyLevel;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, ArchitectureElementsPackage.LOGICAL_ELEMENT__REQUIRED_SAFETY_LEVEL, oldRequiredSafetyLevel, requiredSafetyLevel));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
  {
    switch (featureID)
    {
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__BEHAVIOR:
        return ((InternalEList<?>)getBehavior()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object eGet(int featureID, boolean resolve, boolean coreType)
  {
    switch (featureID)
    {
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__BEHAVIOR:
        return getBehavior();
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__REQUIRED_SAFETY_LEVEL:
        return getRequiredSafetyLevel();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @SuppressWarnings("unchecked")
  @Override
  public void eSet(int featureID, Object newValue)
  {
    switch (featureID)
    {
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__BEHAVIOR:
        getBehavior().clear();
        getBehavior().addAll((Collection<? extends BehaviorSpecification>)newValue);
        return;
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__REQUIRED_SAFETY_LEVEL:
        setRequiredSafetyLevel((SafetyLevel)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void eUnset(int featureID)
  {
    switch (featureID)
    {
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__BEHAVIOR:
        getBehavior().clear();
        return;
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__REQUIRED_SAFETY_LEVEL:
        setRequiredSafetyLevel(REQUIRED_SAFETY_LEVEL_EDEFAULT);
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean eIsSet(int featureID)
  {
    switch (featureID)
    {
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__BEHAVIOR:
        return behavior != null && !behavior.isEmpty();
      case ArchitectureElementsPackage.LOGICAL_ELEMENT__REQUIRED_SAFETY_LEVEL:
        return requiredSafetyLevel != REQUIRED_SAFETY_LEVEL_EDEFAULT;
    }
    return super.eIsSet(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String toString()
  {
    if (eIsProxy()) return super.toString();

    StringBuilder result = new StringBuilder(super.toString());
    result.append(" (requiredSafetyLevel: ");
    result.append(requiredSafetyLevel);
    result.append(')');
    return result.toString();
  }

} //LogicalElementImpl
