/**
 */
package org.fortiss.consistency.viewtypes.basics;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.basics.BasicsFactory
 * @model kind="package"
 * @generated
 */
public interface BasicsPackage extends EPackage
{
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "basics";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http://www.fortiss.org/consistency/viewtypes/basics";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "org.fortiss.consistency.viewtypes.basics";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  BasicsPackage eINSTANCE = org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl.init();

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basics.impl.IIdElementImpl <em>IId Element</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basics.impl.IIdElementImpl
   * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getIIdElement()
   * @generated
   */
  int IID_ELEMENT = 0;

  /**
   * The feature id for the '<em><b>Id</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IID_ELEMENT__ID = 0;

  /**
   * The number of structural features of the '<em>IId Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IID_ELEMENT_FEATURE_COUNT = 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IID_ELEMENT___TO_STRING = 0;

  /**
   * The number of operations of the '<em>IId Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IID_ELEMENT_OPERATION_COUNT = 1;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basics.impl.INamedElementImpl <em>INamed Element</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basics.impl.INamedElementImpl
   * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getINamedElement()
   * @generated
   */
  int INAMED_ELEMENT = 1;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_ELEMENT__NAME = 0;

  /**
   * The number of structural features of the '<em>INamed Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_ELEMENT_FEATURE_COUNT = 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_ELEMENT___TO_STRING = 0;

  /**
   * The number of operations of the '<em>INamed Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_ELEMENT_OPERATION_COUNT = 1;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basics.impl.INamedCommentedElementImpl <em>INamed Commented Element</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basics.impl.INamedCommentedElementImpl
   * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getINamedCommentedElement()
   * @generated
   */
  int INAMED_COMMENTED_ELEMENT = 2;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_COMMENTED_ELEMENT__NAME = INAMED_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Comment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_COMMENTED_ELEMENT__COMMENT = INAMED_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>INamed Commented Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_COMMENTED_ELEMENT_FEATURE_COUNT = INAMED_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_COMMENTED_ELEMENT___TO_STRING = INAMED_ELEMENT_OPERATION_COUNT + 0;

  /**
   * The number of operations of the '<em>INamed Commented Element</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int INAMED_COMMENTED_ELEMENT_OPERATION_COUNT = INAMED_ELEMENT_OPERATION_COUNT + 1;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basics.impl.DataValueImpl <em>Data Value</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basics.impl.DataValueImpl
   * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getDataValue()
   * @generated
   */
  int DATA_VALUE = 3;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_VALUE__NAME = INAMED_COMMENTED_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Comment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_VALUE__COMMENT = INAMED_COMMENTED_ELEMENT__COMMENT;

  /**
   * The feature id for the '<em><b>Value</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_VALUE__VALUE = INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Data Value</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_VALUE_FEATURE_COUNT = INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_VALUE___TO_STRING = INAMED_COMMENTED_ELEMENT_OPERATION_COUNT + 0;

  /**
   * The number of operations of the '<em>Data Value</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int DATA_VALUE_OPERATION_COUNT = INAMED_COMMENTED_ELEMENT_OPERATION_COUNT + 1;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basics.impl.TimedDataValueImpl <em>Timed Data Value</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basics.impl.TimedDataValueImpl
   * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getTimedDataValue()
   * @generated
   */
  int TIMED_DATA_VALUE = 4;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE__NAME = DATA_VALUE__NAME;

  /**
   * The feature id for the '<em><b>Comment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE__COMMENT = DATA_VALUE__COMMENT;

  /**
   * The feature id for the '<em><b>Value</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE__VALUE = DATA_VALUE__VALUE;

  /**
   * The feature id for the '<em><b>Time Stamp</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE__TIME_STAMP = DATA_VALUE_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Timed Data Value</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE_FEATURE_COUNT = DATA_VALUE_FEATURE_COUNT + 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE___TO_STRING = DATA_VALUE_OPERATION_COUNT + 0;

  /**
   * The number of operations of the '<em>Timed Data Value</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int TIMED_DATA_VALUE_OPERATION_COUNT = DATA_VALUE_OPERATION_COUNT + 1;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basics.impl.StringPropertyImpl <em>String Property</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basics.impl.StringPropertyImpl
   * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getStringProperty()
   * @generated
   */
  int STRING_PROPERTY = 5;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STRING_PROPERTY__NAME = INAMED_COMMENTED_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Comment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STRING_PROPERTY__COMMENT = INAMED_COMMENTED_ELEMENT__COMMENT;

  /**
   * The feature id for the '<em><b>String</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STRING_PROPERTY__STRING = INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>String Property</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STRING_PROPERTY_FEATURE_COUNT = INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STRING_PROPERTY___TO_STRING = INAMED_COMMENTED_ELEMENT_OPERATION_COUNT + 0;

  /**
   * The number of operations of the '<em>String Property</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int STRING_PROPERTY_OPERATION_COUNT = INAMED_COMMENTED_ELEMENT_OPERATION_COUNT + 1;


  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basics.IIdElement <em>IId Element</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>IId Element</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.IIdElement
   * @generated
   */
  EClass getIIdElement();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basics.IIdElement#getId <em>Id</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.IIdElement#getId()
   * @see #getIIdElement()
   * @generated
   */
  EAttribute getIIdElement_Id();

  /**
   * Returns the meta object for the '{@link org.fortiss.consistency.viewtypes.basics.IIdElement#toString() <em>To String</em>}' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the '<em>To String</em>' operation.
   * @see org.fortiss.consistency.viewtypes.basics.IIdElement#toString()
   * @generated
   */
  EOperation getIIdElement__ToString();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basics.INamedElement <em>INamed Element</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>INamed Element</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.INamedElement
   * @generated
   */
  EClass getINamedElement();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basics.INamedElement#getName <em>Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Name</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.INamedElement#getName()
   * @see #getINamedElement()
   * @generated
   */
  EAttribute getINamedElement_Name();

  /**
   * Returns the meta object for the '{@link org.fortiss.consistency.viewtypes.basics.INamedElement#toString() <em>To String</em>}' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the '<em>To String</em>' operation.
   * @see org.fortiss.consistency.viewtypes.basics.INamedElement#toString()
   * @generated
   */
  EOperation getINamedElement__ToString();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basics.INamedCommentedElement <em>INamed Commented Element</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>INamed Commented Element</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.INamedCommentedElement
   * @generated
   */
  EClass getINamedCommentedElement();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basics.INamedCommentedElement#getComment <em>Comment</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Comment</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.INamedCommentedElement#getComment()
   * @see #getINamedCommentedElement()
   * @generated
   */
  EAttribute getINamedCommentedElement_Comment();

  /**
   * Returns the meta object for the '{@link org.fortiss.consistency.viewtypes.basics.INamedCommentedElement#toString() <em>To String</em>}' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the '<em>To String</em>' operation.
   * @see org.fortiss.consistency.viewtypes.basics.INamedCommentedElement#toString()
   * @generated
   */
  EOperation getINamedCommentedElement__ToString();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basics.DataValue <em>Data Value</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Data Value</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.DataValue
   * @generated
   */
  EClass getDataValue();

  /**
   * Returns the meta object for the containment reference '{@link org.fortiss.consistency.viewtypes.basics.DataValue#getValue <em>Value</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Value</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.DataValue#getValue()
   * @see #getDataValue()
   * @generated
   */
  EReference getDataValue_Value();

  /**
   * Returns the meta object for the '{@link org.fortiss.consistency.viewtypes.basics.DataValue#toString() <em>To String</em>}' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the '<em>To String</em>' operation.
   * @see org.fortiss.consistency.viewtypes.basics.DataValue#toString()
   * @generated
   */
  EOperation getDataValue__ToString();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basics.TimedDataValue <em>Timed Data Value</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Timed Data Value</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.TimedDataValue
   * @generated
   */
  EClass getTimedDataValue();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basics.TimedDataValue#getTimeStamp <em>Time Stamp</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Time Stamp</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.TimedDataValue#getTimeStamp()
   * @see #getTimedDataValue()
   * @generated
   */
  EAttribute getTimedDataValue_TimeStamp();

  /**
   * Returns the meta object for the '{@link org.fortiss.consistency.viewtypes.basics.TimedDataValue#toString() <em>To String</em>}' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the '<em>To String</em>' operation.
   * @see org.fortiss.consistency.viewtypes.basics.TimedDataValue#toString()
   * @generated
   */
  EOperation getTimedDataValue__ToString();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basics.StringProperty <em>String Property</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>String Property</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.StringProperty
   * @generated
   */
  EClass getStringProperty();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basics.StringProperty#getString <em>String</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>String</em>'.
   * @see org.fortiss.consistency.viewtypes.basics.StringProperty#getString()
   * @see #getStringProperty()
   * @generated
   */
  EAttribute getStringProperty_String();

  /**
   * Returns the meta object for the '{@link org.fortiss.consistency.viewtypes.basics.StringProperty#toString() <em>To String</em>}' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the '<em>To String</em>' operation.
   * @see org.fortiss.consistency.viewtypes.basics.StringProperty#toString()
   * @generated
   */
  EOperation getStringProperty__ToString();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  BasicsFactory getBasicsFactory();

  /**
   * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each operation of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
   * @generated
   */
  interface Literals
  {
    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basics.impl.IIdElementImpl <em>IId Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basics.impl.IIdElementImpl
     * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getIIdElement()
     * @generated
     */
    EClass IID_ELEMENT = eINSTANCE.getIIdElement();

    /**
     * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute IID_ELEMENT__ID = eINSTANCE.getIIdElement_Id();

    /**
     * The meta object literal for the '<em><b>To String</b></em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EOperation IID_ELEMENT___TO_STRING = eINSTANCE.getIIdElement__ToString();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basics.impl.INamedElementImpl <em>INamed Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basics.impl.INamedElementImpl
     * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getINamedElement()
     * @generated
     */
    EClass INAMED_ELEMENT = eINSTANCE.getINamedElement();

    /**
     * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INAMED_ELEMENT__NAME = eINSTANCE.getINamedElement_Name();

    /**
     * The meta object literal for the '<em><b>To String</b></em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EOperation INAMED_ELEMENT___TO_STRING = eINSTANCE.getINamedElement__ToString();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basics.impl.INamedCommentedElementImpl <em>INamed Commented Element</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basics.impl.INamedCommentedElementImpl
     * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getINamedCommentedElement()
     * @generated
     */
    EClass INAMED_COMMENTED_ELEMENT = eINSTANCE.getINamedCommentedElement();

    /**
     * The meta object literal for the '<em><b>Comment</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute INAMED_COMMENTED_ELEMENT__COMMENT = eINSTANCE.getINamedCommentedElement_Comment();

    /**
     * The meta object literal for the '<em><b>To String</b></em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EOperation INAMED_COMMENTED_ELEMENT___TO_STRING = eINSTANCE.getINamedCommentedElement__ToString();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basics.impl.DataValueImpl <em>Data Value</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basics.impl.DataValueImpl
     * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getDataValue()
     * @generated
     */
    EClass DATA_VALUE = eINSTANCE.getDataValue();

    /**
     * The meta object literal for the '<em><b>Value</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference DATA_VALUE__VALUE = eINSTANCE.getDataValue_Value();

    /**
     * The meta object literal for the '<em><b>To String</b></em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EOperation DATA_VALUE___TO_STRING = eINSTANCE.getDataValue__ToString();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basics.impl.TimedDataValueImpl <em>Timed Data Value</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basics.impl.TimedDataValueImpl
     * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getTimedDataValue()
     * @generated
     */
    EClass TIMED_DATA_VALUE = eINSTANCE.getTimedDataValue();

    /**
     * The meta object literal for the '<em><b>Time Stamp</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute TIMED_DATA_VALUE__TIME_STAMP = eINSTANCE.getTimedDataValue_TimeStamp();

    /**
     * The meta object literal for the '<em><b>To String</b></em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EOperation TIMED_DATA_VALUE___TO_STRING = eINSTANCE.getTimedDataValue__ToString();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basics.impl.StringPropertyImpl <em>String Property</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basics.impl.StringPropertyImpl
     * @see org.fortiss.consistency.viewtypes.basics.impl.BasicsPackageImpl#getStringProperty()
     * @generated
     */
    EClass STRING_PROPERTY = eINSTANCE.getStringProperty();

    /**
     * The meta object literal for the '<em><b>String</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute STRING_PROPERTY__STRING = eINSTANCE.getStringProperty_String();

    /**
     * The meta object literal for the '<em><b>To String</b></em>' operation.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EOperation STRING_PROPERTY___TO_STRING = eINSTANCE.getStringProperty__ToString();

  }

} //BasicsPackage
