/**
 */
package org.fortiss.consistency.viewtypes.basics.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.fortiss.consistency.viewtypes.basics.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.basics.BasicsPackage
 * @generated
 */
public class BasicsAdapterFactory extends AdapterFactoryImpl
{
  /**
   * The cached model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static BasicsPackage modelPackage;

  /**
   * Creates an instance of the adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BasicsAdapterFactory()
  {
    if (modelPackage == null)
    {
      modelPackage = BasicsPackage.eINSTANCE;
    }
  }

  /**
   * Returns whether this factory is applicable for the type of the object.
   * <!-- begin-user-doc -->
   * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
   * <!-- end-user-doc -->
   * @return whether this factory is applicable for the type of the object.
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object object)
  {
    if (object == modelPackage)
    {
      return true;
    }
    if (object instanceof EObject)
    {
      return ((EObject)object).eClass().getEPackage() == modelPackage;
    }
    return false;
  }

  /**
   * The switch that delegates to the <code>createXXX</code> methods.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected BasicsSwitch<Adapter> modelSwitch =
    new BasicsSwitch<Adapter>()
    {
      @Override
      public Adapter caseIIdElement(IIdElement object)
      {
        return createIIdElementAdapter();
      }
      @Override
      public Adapter caseINamedElement(INamedElement object)
      {
        return createINamedElementAdapter();
      }
      @Override
      public Adapter caseINamedCommentedElement(INamedCommentedElement object)
      {
        return createINamedCommentedElementAdapter();
      }
      @Override
      public Adapter caseDataValue(DataValue object)
      {
        return createDataValueAdapter();
      }
      @Override
      public Adapter caseTimedDataValue(TimedDataValue object)
      {
        return createTimedDataValueAdapter();
      }
      @Override
      public Adapter caseStringProperty(StringProperty object)
      {
        return createStringPropertyAdapter();
      }
      @Override
      public Adapter defaultCase(EObject object)
      {
        return createEObjectAdapter();
      }
    };

  /**
   * Creates an adapter for the <code>target</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param target the object to adapt.
   * @return the adapter for the <code>target</code>.
   * @generated
   */
  @Override
  public Adapter createAdapter(Notifier target)
  {
    return modelSwitch.doSwitch((EObject)target);
  }


  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.IIdElement <em>IId Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.IIdElement
   * @generated
   */
  public Adapter createIIdElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.INamedElement <em>INamed Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.INamedElement
   * @generated
   */
  public Adapter createINamedElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.INamedCommentedElement <em>INamed Commented Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.INamedCommentedElement
   * @generated
   */
  public Adapter createINamedCommentedElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.DataValue <em>Data Value</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.DataValue
   * @generated
   */
  public Adapter createDataValueAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.TimedDataValue <em>Timed Data Value</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.TimedDataValue
   * @generated
   */
  public Adapter createTimedDataValueAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.StringProperty <em>String Property</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.StringProperty
   * @generated
   */
  public Adapter createStringPropertyAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for the default case.
   * <!-- begin-user-doc -->
   * This default implementation returns null.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @generated
   */
  public Adapter createEObjectAdapter()
  {
    return null;
  }

} //BasicsAdapterFactory
