/**
 */
package org.fortiss.consistency.viewtypes.basysElements;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.basysElements.BasysElementsFactory
 * @model kind="package"
 * @generated
 */
public interface BasysElementsPackage extends EPackage
{
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "basysElements";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http://www.fortiss.org/consistency/viewtypes/basysElements";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "org.fortiss.consistency.viewtypes.basysElements";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  BasysElementsPackage eINSTANCE = org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl.init();

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.IReferableImpl <em>IReferable</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.IReferableImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getIReferable()
   * @generated
   */
  int IREFERABLE = 0;

  /**
   * The feature id for the '<em><b>Id Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IREFERABLE__ID_SHORT = 0;

  /**
   * The feature id for the '<em><b>Category</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IREFERABLE__CATEGORY = 1;

  /**
   * The feature id for the '<em><b>Display Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IREFERABLE__DISPLAY_NAME = 2;

  /**
   * The feature id for the '<em><b>Description</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IREFERABLE__DESCRIPTION = 3;

  /**
   * The number of structural features of the '<em>IReferable</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IREFERABLE_FEATURE_COUNT = 4;

  /**
   * The number of operations of the '<em>IReferable</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IREFERABLE_OPERATION_COUNT = 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.LanguageSpecificStringImpl <em>Language Specific String</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.LanguageSpecificStringImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getLanguageSpecificString()
   * @generated
   */
  int LANGUAGE_SPECIFIC_STRING = 1;

  /**
   * The feature id for the '<em><b>Language</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LANGUAGE_SPECIFIC_STRING__LANGUAGE = 0;

  /**
   * The feature id for the '<em><b>String Value</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LANGUAGE_SPECIFIC_STRING__STRING_VALUE = 1;

  /**
   * The number of structural features of the '<em>Language Specific String</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LANGUAGE_SPECIFIC_STRING_FEATURE_COUNT = 2;

  /**
   * The number of operations of the '<em>Language Specific String</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int LANGUAGE_SPECIFIC_STRING_OPERATION_COUNT = 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.PhoneContactImpl <em>Phone Contact</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.PhoneContactImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getPhoneContact()
   * @generated
   */
  int PHONE_CONTACT = 2;

  /**
   * The feature id for the '<em><b>Id Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__ID_SHORT = IREFERABLE__ID_SHORT;

  /**
   * The feature id for the '<em><b>Category</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__CATEGORY = IREFERABLE__CATEGORY;

  /**
   * The feature id for the '<em><b>Display Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__DISPLAY_NAME = IREFERABLE__DISPLAY_NAME;

  /**
   * The feature id for the '<em><b>Description</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__DESCRIPTION = IREFERABLE__DESCRIPTION;

  /**
   * The feature id for the '<em><b>Telephone Type</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__TELEPHONE_TYPE = IREFERABLE_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Telephone Number</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__TELEPHONE_NUMBER = IREFERABLE_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Available Time</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT__AVAILABLE_TIME = IREFERABLE_FEATURE_COUNT + 2;

  /**
   * The number of structural features of the '<em>Phone Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 3;

  /**
   * The number of operations of the '<em>Phone Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int PHONE_CONTACT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.IpCommunicationContactImpl <em>Ip Communication Contact</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.IpCommunicationContactImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getIpCommunicationContact()
   * @generated
   */
  int IP_COMMUNICATION_CONTACT = 3;

  /**
   * The feature id for the '<em><b>Id Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__ID_SHORT = IREFERABLE__ID_SHORT;

  /**
   * The feature id for the '<em><b>Category</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__CATEGORY = IREFERABLE__CATEGORY;

  /**
   * The feature id for the '<em><b>Display Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__DISPLAY_NAME = IREFERABLE__DISPLAY_NAME;

  /**
   * The feature id for the '<em><b>Description</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__DESCRIPTION = IREFERABLE__DESCRIPTION;

  /**
   * The feature id for the '<em><b>Communication Type</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__COMMUNICATION_TYPE = IREFERABLE_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Address Of Additional Link</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__ADDRESS_OF_ADDITIONAL_LINK = IREFERABLE_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Available Time</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT__AVAILABLE_TIME = IREFERABLE_FEATURE_COUNT + 2;

  /**
   * The number of structural features of the '<em>Ip Communication Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 3;

  /**
   * The number of operations of the '<em>Ip Communication Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int IP_COMMUNICATION_CONTACT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.FaxContactImpl <em>Fax Contact</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.FaxContactImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getFaxContact()
   * @generated
   */
  int FAX_CONTACT = 4;

  /**
   * The feature id for the '<em><b>Id Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT__ID_SHORT = IREFERABLE__ID_SHORT;

  /**
   * The feature id for the '<em><b>Category</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT__CATEGORY = IREFERABLE__CATEGORY;

  /**
   * The feature id for the '<em><b>Display Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT__DISPLAY_NAME = IREFERABLE__DISPLAY_NAME;

  /**
   * The feature id for the '<em><b>Description</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT__DESCRIPTION = IREFERABLE__DESCRIPTION;

  /**
   * The feature id for the '<em><b>Fax Type</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT__FAX_TYPE = IREFERABLE_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Fax Number</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT__FAX_NUMBER = IREFERABLE_FEATURE_COUNT + 1;

  /**
   * The number of structural features of the '<em>Fax Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 2;

  /**
   * The number of operations of the '<em>Fax Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int FAX_CONTACT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.EmailContactImpl <em>Email Contact</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.EmailContactImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getEmailContact()
   * @generated
   */
  int EMAIL_CONTACT = 5;

  /**
   * The feature id for the '<em><b>Id Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__ID_SHORT = IREFERABLE__ID_SHORT;

  /**
   * The feature id for the '<em><b>Category</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__CATEGORY = IREFERABLE__CATEGORY;

  /**
   * The feature id for the '<em><b>Display Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__DISPLAY_NAME = IREFERABLE__DISPLAY_NAME;

  /**
   * The feature id for the '<em><b>Description</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__DESCRIPTION = IREFERABLE__DESCRIPTION;

  /**
   * The feature id for the '<em><b>Public Key Type</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__PUBLIC_KEY_TYPE = IREFERABLE_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Email Address Type</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__EMAIL_ADDRESS_TYPE = IREFERABLE_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Public Key</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__PUBLIC_KEY = IREFERABLE_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Email Address</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT__EMAIL_ADDRESS = IREFERABLE_FEATURE_COUNT + 3;

  /**
   * The number of structural features of the '<em>Email Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 4;

  /**
   * The number of operations of the '<em>Email Contact</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int EMAIL_CONTACT_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.ContactInformationImpl <em>Contact Information</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.ContactInformationImpl
   * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getContactInformation()
   * @generated
   */
  int CONTACT_INFORMATION = 6;

  /**
   * The feature id for the '<em><b>Id Short</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__ID_SHORT = IREFERABLE__ID_SHORT;

  /**
   * The feature id for the '<em><b>Category</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__CATEGORY = IREFERABLE__CATEGORY;

  /**
   * The feature id for the '<em><b>Display Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__DISPLAY_NAME = IREFERABLE__DISPLAY_NAME;

  /**
   * The feature id for the '<em><b>Description</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__DESCRIPTION = IREFERABLE__DESCRIPTION;

  /**
   * The feature id for the '<em><b>Zip Code</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__ZIP_CODE = IREFERABLE_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Zip Code Of Po Box</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__ZIP_CODE_OF_PO_BOX = IREFERABLE_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Title</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__TITLE = IREFERABLE_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Time Zone</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__TIME_ZONE = IREFERABLE_FEATURE_COUNT + 3;

  /**
   * The feature id for the '<em><b>Street</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__STREET = IREFERABLE_FEATURE_COUNT + 4;

  /**
   * The feature id for the '<em><b>State County</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__STATE_COUNTY = IREFERABLE_FEATURE_COUNT + 5;

  /**
   * The feature id for the '<em><b>Role Of Contact Person</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__ROLE_OF_CONTACT_PERSON = IREFERABLE_FEATURE_COUNT + 6;

  /**
   * The feature id for the '<em><b>Phone</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__PHONE = IREFERABLE_FEATURE_COUNT + 7;

  /**
   * The feature id for the '<em><b>Po Box</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__PO_BOX = IREFERABLE_FEATURE_COUNT + 8;

  /**
   * The feature id for the '<em><b>National Code</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__NATIONAL_CODE = IREFERABLE_FEATURE_COUNT + 9;

  /**
   * The feature id for the '<em><b>Name Of Contact</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__NAME_OF_CONTACT = IREFERABLE_FEATURE_COUNT + 10;

  /**
   * The feature id for the '<em><b>Middle Names</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__MIDDLE_NAMES = IREFERABLE_FEATURE_COUNT + 11;

  /**
   * The feature id for the '<em><b>Language</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__LANGUAGE = IREFERABLE_FEATURE_COUNT + 12;

  /**
   * The feature id for the '<em><b>Ip Communication</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__IP_COMMUNICATION = IREFERABLE_FEATURE_COUNT + 13;

  /**
   * The feature id for the '<em><b>Further Details Of Contact</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__FURTHER_DETAILS_OF_CONTACT = IREFERABLE_FEATURE_COUNT + 14;

  /**
   * The feature id for the '<em><b>First Name</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__FIRST_NAME = IREFERABLE_FEATURE_COUNT + 15;

  /**
   * The feature id for the '<em><b>Fax</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__FAX = IREFERABLE_FEATURE_COUNT + 16;

  /**
   * The feature id for the '<em><b>Email</b></em>' containment reference.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__EMAIL = IREFERABLE_FEATURE_COUNT + 17;

  /**
   * The feature id for the '<em><b>Department</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__DEPARTMENT = IREFERABLE_FEATURE_COUNT + 18;

  /**
   * The feature id for the '<em><b>Company</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__COMPANY = IREFERABLE_FEATURE_COUNT + 19;

  /**
   * The feature id for the '<em><b>City Town</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__CITY_TOWN = IREFERABLE_FEATURE_COUNT + 20;

  /**
   * The feature id for the '<em><b>Address Of Additional Link</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__ADDRESS_OF_ADDITIONAL_LINK = IREFERABLE_FEATURE_COUNT + 21;

  /**
   * The feature id for the '<em><b>Academic Title</b></em>' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION__ACADEMIC_TITLE = IREFERABLE_FEATURE_COUNT + 22;

  /**
   * The number of structural features of the '<em>Contact Information</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION_FEATURE_COUNT = IREFERABLE_FEATURE_COUNT + 23;

  /**
   * The number of operations of the '<em>Contact Information</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int CONTACT_INFORMATION_OPERATION_COUNT = IREFERABLE_OPERATION_COUNT + 0;


  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.IReferable <em>IReferable</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>IReferable</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IReferable
   * @generated
   */
  EClass getIReferable();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.IReferable#getIdShort <em>Id Short</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Id Short</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IReferable#getIdShort()
   * @see #getIReferable()
   * @generated
   */
  EAttribute getIReferable_IdShort();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.IReferable#getCategory <em>Category</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Category</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IReferable#getCategory()
   * @see #getIReferable()
   * @generated
   */
  EAttribute getIReferable_Category();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.IReferable#getDisplayName <em>Display Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Display Name</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IReferable#getDisplayName()
   * @see #getIReferable()
   * @generated
   */
  EReference getIReferable_DisplayName();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.IReferable#getDescription <em>Description</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Description</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IReferable#getDescription()
   * @see #getIReferable()
   * @generated
   */
  EReference getIReferable_Description();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.LanguageSpecificString <em>Language Specific String</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Language Specific String</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.LanguageSpecificString
   * @generated
   */
  EClass getLanguageSpecificString();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.LanguageSpecificString#getLanguage <em>Language</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Language</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.LanguageSpecificString#getLanguage()
   * @see #getLanguageSpecificString()
   * @generated
   */
  EAttribute getLanguageSpecificString_Language();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.LanguageSpecificString#getStringValue <em>String Value</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>String Value</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.LanguageSpecificString#getStringValue()
   * @see #getLanguageSpecificString()
   * @generated
   */
  EAttribute getLanguageSpecificString_StringValue();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.PhoneContact <em>Phone Contact</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Phone Contact</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.PhoneContact
   * @generated
   */
  EClass getPhoneContact();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.PhoneContact#getTelephoneType <em>Telephone Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Telephone Type</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.PhoneContact#getTelephoneType()
   * @see #getPhoneContact()
   * @generated
   */
  EAttribute getPhoneContact_TelephoneType();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.PhoneContact#getTelephoneNumber <em>Telephone Number</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Telephone Number</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.PhoneContact#getTelephoneNumber()
   * @see #getPhoneContact()
   * @generated
   */
  EReference getPhoneContact_TelephoneNumber();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.PhoneContact#getAvailableTime <em>Available Time</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Available Time</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.PhoneContact#getAvailableTime()
   * @see #getPhoneContact()
   * @generated
   */
  EReference getPhoneContact_AvailableTime();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact <em>Ip Communication Contact</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Ip Communication Contact</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact
   * @generated
   */
  EClass getIpCommunicationContact();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact#getCommunicationType <em>Communication Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Communication Type</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact#getCommunicationType()
   * @see #getIpCommunicationContact()
   * @generated
   */
  EAttribute getIpCommunicationContact_CommunicationType();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact#getAddressOfAdditionalLink <em>Address Of Additional Link</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Address Of Additional Link</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact#getAddressOfAdditionalLink()
   * @see #getIpCommunicationContact()
   * @generated
   */
  EAttribute getIpCommunicationContact_AddressOfAdditionalLink();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact#getAvailableTime <em>Available Time</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Available Time</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.IpCommunicationContact#getAvailableTime()
   * @see #getIpCommunicationContact()
   * @generated
   */
  EReference getIpCommunicationContact_AvailableTime();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.FaxContact <em>Fax Contact</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Fax Contact</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.FaxContact
   * @generated
   */
  EClass getFaxContact();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.FaxContact#getFaxType <em>Fax Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Fax Type</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.FaxContact#getFaxType()
   * @see #getFaxContact()
   * @generated
   */
  EAttribute getFaxContact_FaxType();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.FaxContact#getFaxNumber <em>Fax Number</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Fax Number</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.FaxContact#getFaxNumber()
   * @see #getFaxContact()
   * @generated
   */
  EReference getFaxContact_FaxNumber();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.EmailContact <em>Email Contact</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Email Contact</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.EmailContact
   * @generated
   */
  EClass getEmailContact();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.EmailContact#getPublicKeyType <em>Public Key Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Public Key Type</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.EmailContact#getPublicKeyType()
   * @see #getEmailContact()
   * @generated
   */
  EReference getEmailContact_PublicKeyType();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.EmailContact#getEmailAddressType <em>Email Address Type</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Email Address Type</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.EmailContact#getEmailAddressType()
   * @see #getEmailContact()
   * @generated
   */
  EAttribute getEmailContact_EmailAddressType();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.EmailContact#getPublicKey <em>Public Key</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Public Key</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.EmailContact#getPublicKey()
   * @see #getEmailContact()
   * @generated
   */
  EReference getEmailContact_PublicKey();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.EmailContact#getEmailAddress <em>Email Address</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Email Address</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.EmailContact#getEmailAddress()
   * @see #getEmailContact()
   * @generated
   */
  EAttribute getEmailContact_EmailAddress();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation <em>Contact Information</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Contact Information</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation
   * @generated
   */
  EClass getContactInformation();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getZipCode <em>Zip Code</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Zip Code</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getZipCode()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_ZipCode();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getZipCodeOfPoBox <em>Zip Code Of Po Box</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Zip Code Of Po Box</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getZipCodeOfPoBox()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_ZipCodeOfPoBox();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getTitle <em>Title</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Title</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getTitle()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Title();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getTimeZone <em>Time Zone</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Time Zone</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getTimeZone()
   * @see #getContactInformation()
   * @generated
   */
  EAttribute getContactInformation_TimeZone();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getStreet <em>Street</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Street</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getStreet()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Street();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getStateCounty <em>State County</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>State County</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getStateCounty()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_StateCounty();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getRoleOfContactPerson <em>Role Of Contact Person</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Role Of Contact Person</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getRoleOfContactPerson()
   * @see #getContactInformation()
   * @generated
   */
  EAttribute getContactInformation_RoleOfContactPerson();

  /**
   * Returns the meta object for the containment reference '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getPhone <em>Phone</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Phone</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getPhone()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Phone();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getPoBox <em>Po Box</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Po Box</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getPoBox()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_PoBox();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getNationalCode <em>National Code</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>National Code</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getNationalCode()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_NationalCode();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getNameOfContact <em>Name Of Contact</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Name Of Contact</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getNameOfContact()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_NameOfContact();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getMiddleNames <em>Middle Names</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Middle Names</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getMiddleNames()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_MiddleNames();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getLanguage <em>Language</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Language</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getLanguage()
   * @see #getContactInformation()
   * @generated
   */
  EAttribute getContactInformation_Language();

  /**
   * Returns the meta object for the containment reference '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getIpCommunication <em>Ip Communication</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Ip Communication</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getIpCommunication()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_IpCommunication();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getFurtherDetailsOfContact <em>Further Details Of Contact</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Further Details Of Contact</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getFurtherDetailsOfContact()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_FurtherDetailsOfContact();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getFirstName <em>First Name</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>First Name</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getFirstName()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_FirstName();

  /**
   * Returns the meta object for the containment reference '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getFax <em>Fax</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Fax</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getFax()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Fax();

  /**
   * Returns the meta object for the containment reference '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getEmail <em>Email</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference '<em>Email</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getEmail()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Email();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getDepartment <em>Department</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Department</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getDepartment()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Department();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getCompany <em>Company</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Company</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getCompany()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_Company();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getCityTown <em>City Town</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>City Town</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getCityTown()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_CityTown();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getAddressOfAdditionalLink <em>Address Of Additional Link</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Address Of Additional Link</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getAddressOfAdditionalLink()
   * @see #getContactInformation()
   * @generated
   */
  EAttribute getContactInformation_AddressOfAdditionalLink();

  /**
   * Returns the meta object for the containment reference list '{@link org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getAcademicTitle <em>Academic Title</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the containment reference list '<em>Academic Title</em>'.
   * @see org.fortiss.consistency.viewtypes.basysElements.ContactInformation#getAcademicTitle()
   * @see #getContactInformation()
   * @generated
   */
  EReference getContactInformation_AcademicTitle();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  BasysElementsFactory getBasysElementsFactory();

  /**
   * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each operation of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
   * @generated
   */
  interface Literals
  {
    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.IReferableImpl <em>IReferable</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.IReferableImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getIReferable()
     * @generated
     */
    EClass IREFERABLE = eINSTANCE.getIReferable();

    /**
     * The meta object literal for the '<em><b>Id Short</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute IREFERABLE__ID_SHORT = eINSTANCE.getIReferable_IdShort();

    /**
     * The meta object literal for the '<em><b>Category</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute IREFERABLE__CATEGORY = eINSTANCE.getIReferable_Category();

    /**
     * The meta object literal for the '<em><b>Display Name</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference IREFERABLE__DISPLAY_NAME = eINSTANCE.getIReferable_DisplayName();

    /**
     * The meta object literal for the '<em><b>Description</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference IREFERABLE__DESCRIPTION = eINSTANCE.getIReferable_Description();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.LanguageSpecificStringImpl <em>Language Specific String</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.LanguageSpecificStringImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getLanguageSpecificString()
     * @generated
     */
    EClass LANGUAGE_SPECIFIC_STRING = eINSTANCE.getLanguageSpecificString();

    /**
     * The meta object literal for the '<em><b>Language</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LANGUAGE_SPECIFIC_STRING__LANGUAGE = eINSTANCE.getLanguageSpecificString_Language();

    /**
     * The meta object literal for the '<em><b>String Value</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute LANGUAGE_SPECIFIC_STRING__STRING_VALUE = eINSTANCE.getLanguageSpecificString_StringValue();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.PhoneContactImpl <em>Phone Contact</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.PhoneContactImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getPhoneContact()
     * @generated
     */
    EClass PHONE_CONTACT = eINSTANCE.getPhoneContact();

    /**
     * The meta object literal for the '<em><b>Telephone Type</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute PHONE_CONTACT__TELEPHONE_TYPE = eINSTANCE.getPhoneContact_TelephoneType();

    /**
     * The meta object literal for the '<em><b>Telephone Number</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference PHONE_CONTACT__TELEPHONE_NUMBER = eINSTANCE.getPhoneContact_TelephoneNumber();

    /**
     * The meta object literal for the '<em><b>Available Time</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference PHONE_CONTACT__AVAILABLE_TIME = eINSTANCE.getPhoneContact_AvailableTime();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.IpCommunicationContactImpl <em>Ip Communication Contact</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.IpCommunicationContactImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getIpCommunicationContact()
     * @generated
     */
    EClass IP_COMMUNICATION_CONTACT = eINSTANCE.getIpCommunicationContact();

    /**
     * The meta object literal for the '<em><b>Communication Type</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute IP_COMMUNICATION_CONTACT__COMMUNICATION_TYPE = eINSTANCE.getIpCommunicationContact_CommunicationType();

    /**
     * The meta object literal for the '<em><b>Address Of Additional Link</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute IP_COMMUNICATION_CONTACT__ADDRESS_OF_ADDITIONAL_LINK = eINSTANCE.getIpCommunicationContact_AddressOfAdditionalLink();

    /**
     * The meta object literal for the '<em><b>Available Time</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference IP_COMMUNICATION_CONTACT__AVAILABLE_TIME = eINSTANCE.getIpCommunicationContact_AvailableTime();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.FaxContactImpl <em>Fax Contact</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.FaxContactImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getFaxContact()
     * @generated
     */
    EClass FAX_CONTACT = eINSTANCE.getFaxContact();

    /**
     * The meta object literal for the '<em><b>Fax Type</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute FAX_CONTACT__FAX_TYPE = eINSTANCE.getFaxContact_FaxType();

    /**
     * The meta object literal for the '<em><b>Fax Number</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference FAX_CONTACT__FAX_NUMBER = eINSTANCE.getFaxContact_FaxNumber();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.EmailContactImpl <em>Email Contact</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.EmailContactImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getEmailContact()
     * @generated
     */
    EClass EMAIL_CONTACT = eINSTANCE.getEmailContact();

    /**
     * The meta object literal for the '<em><b>Public Key Type</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference EMAIL_CONTACT__PUBLIC_KEY_TYPE = eINSTANCE.getEmailContact_PublicKeyType();

    /**
     * The meta object literal for the '<em><b>Email Address Type</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute EMAIL_CONTACT__EMAIL_ADDRESS_TYPE = eINSTANCE.getEmailContact_EmailAddressType();

    /**
     * The meta object literal for the '<em><b>Public Key</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference EMAIL_CONTACT__PUBLIC_KEY = eINSTANCE.getEmailContact_PublicKey();

    /**
     * The meta object literal for the '<em><b>Email Address</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute EMAIL_CONTACT__EMAIL_ADDRESS = eINSTANCE.getEmailContact_EmailAddress();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.basysElements.impl.ContactInformationImpl <em>Contact Information</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.ContactInformationImpl
     * @see org.fortiss.consistency.viewtypes.basysElements.impl.BasysElementsPackageImpl#getContactInformation()
     * @generated
     */
    EClass CONTACT_INFORMATION = eINSTANCE.getContactInformation();

    /**
     * The meta object literal for the '<em><b>Zip Code</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__ZIP_CODE = eINSTANCE.getContactInformation_ZipCode();

    /**
     * The meta object literal for the '<em><b>Zip Code Of Po Box</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__ZIP_CODE_OF_PO_BOX = eINSTANCE.getContactInformation_ZipCodeOfPoBox();

    /**
     * The meta object literal for the '<em><b>Title</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__TITLE = eINSTANCE.getContactInformation_Title();

    /**
     * The meta object literal for the '<em><b>Time Zone</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CONTACT_INFORMATION__TIME_ZONE = eINSTANCE.getContactInformation_TimeZone();

    /**
     * The meta object literal for the '<em><b>Street</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__STREET = eINSTANCE.getContactInformation_Street();

    /**
     * The meta object literal for the '<em><b>State County</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__STATE_COUNTY = eINSTANCE.getContactInformation_StateCounty();

    /**
     * The meta object literal for the '<em><b>Role Of Contact Person</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CONTACT_INFORMATION__ROLE_OF_CONTACT_PERSON = eINSTANCE.getContactInformation_RoleOfContactPerson();

    /**
     * The meta object literal for the '<em><b>Phone</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__PHONE = eINSTANCE.getContactInformation_Phone();

    /**
     * The meta object literal for the '<em><b>Po Box</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__PO_BOX = eINSTANCE.getContactInformation_PoBox();

    /**
     * The meta object literal for the '<em><b>National Code</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__NATIONAL_CODE = eINSTANCE.getContactInformation_NationalCode();

    /**
     * The meta object literal for the '<em><b>Name Of Contact</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__NAME_OF_CONTACT = eINSTANCE.getContactInformation_NameOfContact();

    /**
     * The meta object literal for the '<em><b>Middle Names</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__MIDDLE_NAMES = eINSTANCE.getContactInformation_MiddleNames();

    /**
     * The meta object literal for the '<em><b>Language</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CONTACT_INFORMATION__LANGUAGE = eINSTANCE.getContactInformation_Language();

    /**
     * The meta object literal for the '<em><b>Ip Communication</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__IP_COMMUNICATION = eINSTANCE.getContactInformation_IpCommunication();

    /**
     * The meta object literal for the '<em><b>Further Details Of Contact</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__FURTHER_DETAILS_OF_CONTACT = eINSTANCE.getContactInformation_FurtherDetailsOfContact();

    /**
     * The meta object literal for the '<em><b>First Name</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__FIRST_NAME = eINSTANCE.getContactInformation_FirstName();

    /**
     * The meta object literal for the '<em><b>Fax</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__FAX = eINSTANCE.getContactInformation_Fax();

    /**
     * The meta object literal for the '<em><b>Email</b></em>' containment reference feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__EMAIL = eINSTANCE.getContactInformation_Email();

    /**
     * The meta object literal for the '<em><b>Department</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__DEPARTMENT = eINSTANCE.getContactInformation_Department();

    /**
     * The meta object literal for the '<em><b>Company</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__COMPANY = eINSTANCE.getContactInformation_Company();

    /**
     * The meta object literal for the '<em><b>City Town</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__CITY_TOWN = eINSTANCE.getContactInformation_CityTown();

    /**
     * The meta object literal for the '<em><b>Address Of Additional Link</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute CONTACT_INFORMATION__ADDRESS_OF_ADDITIONAL_LINK = eINSTANCE.getContactInformation_AddressOfAdditionalLink();

    /**
     * The meta object literal for the '<em><b>Academic Title</b></em>' containment reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference CONTACT_INFORMATION__ACADEMIC_TITLE = eINSTANCE.getContactInformation_AcademicTitle();

  }

} //BasysElementsPackage
