/**
 */
package org.fortiss.consistency.viewtypes.basysElements.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.fortiss.consistency.viewtypes.basysElements.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.basysElements.BasysElementsPackage
 * @generated
 */
public class BasysElementsSwitch<T> extends Switch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static BasysElementsPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public BasysElementsSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = BasysElementsPackage.eINSTANCE;
    }
  }

  /**
   * Checks whether this is a switch for the given package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param ePackage the package in question.
   * @return whether this is a switch for the given package.
   * @generated
   */
  @Override
  protected boolean isSwitchFor(EPackage ePackage)
  {
    return ePackage == modelPackage;
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  @Override
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case BasysElementsPackage.IREFERABLE:
      {
        IReferable iReferable = (IReferable)theEObject;
        T result = caseIReferable(iReferable);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case BasysElementsPackage.LANGUAGE_SPECIFIC_STRING:
      {
        LanguageSpecificString languageSpecificString = (LanguageSpecificString)theEObject;
        T result = caseLanguageSpecificString(languageSpecificString);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case BasysElementsPackage.PHONE_CONTACT:
      {
        PhoneContact phoneContact = (PhoneContact)theEObject;
        T result = casePhoneContact(phoneContact);
        if (result == null) result = caseIReferable(phoneContact);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case BasysElementsPackage.IP_COMMUNICATION_CONTACT:
      {
        IpCommunicationContact ipCommunicationContact = (IpCommunicationContact)theEObject;
        T result = caseIpCommunicationContact(ipCommunicationContact);
        if (result == null) result = caseIReferable(ipCommunicationContact);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case BasysElementsPackage.FAX_CONTACT:
      {
        FaxContact faxContact = (FaxContact)theEObject;
        T result = caseFaxContact(faxContact);
        if (result == null) result = caseIReferable(faxContact);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case BasysElementsPackage.EMAIL_CONTACT:
      {
        EmailContact emailContact = (EmailContact)theEObject;
        T result = caseEmailContact(emailContact);
        if (result == null) result = caseIReferable(emailContact);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case BasysElementsPackage.CONTACT_INFORMATION:
      {
        ContactInformation contactInformation = (ContactInformation)theEObject;
        T result = caseContactInformation(contactInformation);
        if (result == null) result = caseIReferable(contactInformation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>IReferable</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>IReferable</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIReferable(IReferable object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Language Specific String</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Language Specific String</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseLanguageSpecificString(LanguageSpecificString object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Phone Contact</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Phone Contact</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePhoneContact(PhoneContact object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Ip Communication Contact</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Ip Communication Contact</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseIpCommunicationContact(IpCommunicationContact object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Fax Contact</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Fax Contact</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFaxContact(FaxContact object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Email Contact</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Email Contact</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEmailContact(EmailContact object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Contact Information</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Contact Information</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseContactInformation(ContactInformation object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  @Override
  public T defaultCase(EObject object)
  {
    return null;
  }

} //BasysElementsSwitch
