/**
 */
package org.fortiss.consistency.viewtypes.dictionary.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.fortiss.consistency.viewtypes.basics.BasicsPackage;
import org.fortiss.consistency.viewtypes.basics.IIdElement;
import org.fortiss.consistency.viewtypes.basics.INamedElement;

import org.fortiss.consistency.viewtypes.basics.impl.IIdElementImpl;

import org.fortiss.consistency.viewtypes.dictionary.Dictionary;
import org.fortiss.consistency.viewtypes.dictionary.DictionaryElement;
import org.fortiss.consistency.viewtypes.dictionary.DictionaryPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Dictionary</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.fortiss.consistency.viewtypes.dictionary.impl.DictionaryImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.fortiss.consistency.viewtypes.dictionary.impl.DictionaryImpl#getContainedElements <em>Contained Elements</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DictionaryImpl extends IIdElementImpl implements Dictionary
{
  /**
   * The default value of the '{@link #getName() <em>Name</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getName()
   * @generated
   * @ordered
   */
  protected static final String NAME_EDEFAULT = null;

  /**
   * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getName()
   * @generated
   * @ordered
   */
  protected String name = NAME_EDEFAULT;

  /**
   * The cached value of the '{@link #getContainedElements() <em>Contained Elements</em>}' containment reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #getContainedElements()
   * @generated
   * @ordered
   */
  protected EList<DictionaryElement> containedElements;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected DictionaryImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  protected EClass eStaticClass()
  {
    return DictionaryPackage.Literals.DICTIONARY;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String getName()
  {
    return name;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public void setName(String newName)
  {
    String oldName = name;
    name = newName;
    if (eNotificationRequired())
      eNotify(new ENotificationImpl(this, Notification.SET, DictionaryPackage.DICTIONARY__NAME, oldName, name));
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EList<DictionaryElement> getContainedElements()
  {
    if (containedElements == null)
    {
      containedElements = new EObjectContainmentEList<DictionaryElement>(DictionaryElement.class, this, DictionaryPackage.DICTIONARY__CONTAINED_ELEMENTS);
    }
    return containedElements;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String toString()
  {
    return "INamedElement[Name: '" + this.name + "']";
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
  {
    switch (featureID)
    {
      case DictionaryPackage.DICTIONARY__CONTAINED_ELEMENTS:
        return ((InternalEList<?>)getContainedElements()).basicRemove(otherEnd, msgs);
    }
    return super.eInverseRemove(otherEnd, featureID, msgs);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object eGet(int featureID, boolean resolve, boolean coreType)
  {
    switch (featureID)
    {
      case DictionaryPackage.DICTIONARY__NAME:
        return getName();
      case DictionaryPackage.DICTIONARY__CONTAINED_ELEMENTS:
        return getContainedElements();
    }
    return super.eGet(featureID, resolve, coreType);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @SuppressWarnings("unchecked")
  @Override
  public void eSet(int featureID, Object newValue)
  {
    switch (featureID)
    {
      case DictionaryPackage.DICTIONARY__NAME:
        setName((String)newValue);
        return;
      case DictionaryPackage.DICTIONARY__CONTAINED_ELEMENTS:
        getContainedElements().clear();
        getContainedElements().addAll((Collection<? extends DictionaryElement>)newValue);
        return;
    }
    super.eSet(featureID, newValue);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public void eUnset(int featureID)
  {
    switch (featureID)
    {
      case DictionaryPackage.DICTIONARY__NAME:
        setName(NAME_EDEFAULT);
        return;
      case DictionaryPackage.DICTIONARY__CONTAINED_ELEMENTS:
        getContainedElements().clear();
        return;
    }
    super.eUnset(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public boolean eIsSet(int featureID)
  {
    switch (featureID)
    {
      case DictionaryPackage.DICTIONARY__NAME:
        return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
      case DictionaryPackage.DICTIONARY__CONTAINED_ELEMENTS:
        return containedElements != null && !containedElements.isEmpty();
    }
    return super.eIsSet(featureID);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass)
  {
    if (baseClass == INamedElement.class)
    {
      switch (derivedFeatureID)
      {
        case DictionaryPackage.DICTIONARY__NAME: return BasicsPackage.INAMED_ELEMENT__NAME;
        default: return -1;
      }
    }
    return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass)
  {
    if (baseClass == INamedElement.class)
    {
      switch (baseFeatureID)
      {
        case BasicsPackage.INAMED_ELEMENT__NAME: return DictionaryPackage.DICTIONARY__NAME;
        default: return -1;
      }
    }
    return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public int eDerivedOperationID(int baseOperationID, Class<?> baseClass)
  {
    if (baseClass == IIdElement.class)
    {
      switch (baseOperationID)
      {
        case BasicsPackage.IID_ELEMENT___TO_STRING: return DictionaryPackage.DICTIONARY___TO_STRING;
        default: return super.eDerivedOperationID(baseOperationID, baseClass);
      }
    }
    if (baseClass == INamedElement.class)
    {
      switch (baseOperationID)
      {
        case BasicsPackage.INAMED_ELEMENT___TO_STRING: return DictionaryPackage.DICTIONARY___TO_STRING;
        default: return -1;
      }
    }
    return super.eDerivedOperationID(baseOperationID, baseClass);
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException
  {
    switch (operationID)
    {
      case DictionaryPackage.DICTIONARY___TO_STRING:
        return toString();
    }
    return super.eInvoke(operationID, arguments);
  }

} //DictionaryImpl
