/**
 */
package org.fortiss.consistency.viewtypes.geometryElements.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.fortiss.consistency.viewtypes.basics.INamedCommentedElement;
import org.fortiss.consistency.viewtypes.basics.INamedElement;

import org.fortiss.consistency.viewtypes.geometryElements.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.geometryElements.GeometryElementsPackage
 * @generated
 */
public class GeometryElementsAdapterFactory extends AdapterFactoryImpl
{
  /**
   * The cached model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static GeometryElementsPackage modelPackage;

  /**
   * Creates an instance of the adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public GeometryElementsAdapterFactory()
  {
    if (modelPackage == null)
    {
      modelPackage = GeometryElementsPackage.eINSTANCE;
    }
  }

  /**
   * Returns whether this factory is applicable for the type of the object.
   * <!-- begin-user-doc -->
   * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
   * <!-- end-user-doc -->
   * @return whether this factory is applicable for the type of the object.
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object object)
  {
    if (object == modelPackage)
    {
      return true;
    }
    if (object instanceof EObject)
    {
      return ((EObject)object).eClass().getEPackage() == modelPackage;
    }
    return false;
  }

  /**
   * The switch that delegates to the <code>createXXX</code> methods.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected GeometryElementsSwitch<Adapter> modelSwitch =
    new GeometryElementsSwitch<Adapter>()
    {
      @Override
      public Adapter caseGeometry(Geometry object)
      {
        return createGeometryAdapter();
      }
      @Override
      public Adapter caseGeometryElement(GeometryElement object)
      {
        return createGeometryElementAdapter();
      }
      @Override
      public Adapter casePlaceholderElement(PlaceholderElement object)
      {
        return createPlaceholderElementAdapter();
      }
      @Override
      public Adapter caseOrigin(Origin object)
      {
        return createOriginAdapter();
      }
      @Override
      public Adapter caseSphere(Sphere object)
      {
        return createSphereAdapter();
      }
      @Override
      public Adapter caseCube(Cube object)
      {
        return createCubeAdapter();
      }
      @Override
      public Adapter caseCuboid(Cuboid object)
      {
        return createCuboidAdapter();
      }
      @Override
      public Adapter casePlane(Plane object)
      {
        return createPlaneAdapter();
      }
      @Override
      public Adapter caseINamedElement(INamedElement object)
      {
        return createINamedElementAdapter();
      }
      @Override
      public Adapter caseINamedCommentedElement(INamedCommentedElement object)
      {
        return createINamedCommentedElementAdapter();
      }
      @Override
      public Adapter defaultCase(EObject object)
      {
        return createEObjectAdapter();
      }
    };

  /**
   * Creates an adapter for the <code>target</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param target the object to adapt.
   * @return the adapter for the <code>target</code>.
   * @generated
   */
  @Override
  public Adapter createAdapter(Notifier target)
  {
    return modelSwitch.doSwitch((EObject)target);
  }


  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.Geometry <em>Geometry</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.Geometry
   * @generated
   */
  public Adapter createGeometryAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.GeometryElement <em>Geometry Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.GeometryElement
   * @generated
   */
  public Adapter createGeometryElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.PlaceholderElement <em>Placeholder Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.PlaceholderElement
   * @generated
   */
  public Adapter createPlaceholderElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.Origin <em>Origin</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.Origin
   * @generated
   */
  public Adapter createOriginAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.Sphere <em>Sphere</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.Sphere
   * @generated
   */
  public Adapter createSphereAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.Cube <em>Cube</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.Cube
   * @generated
   */
  public Adapter createCubeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.Cuboid <em>Cuboid</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.Cuboid
   * @generated
   */
  public Adapter createCuboidAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.geometryElements.Plane <em>Plane</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.geometryElements.Plane
   * @generated
   */
  public Adapter createPlaneAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.INamedElement <em>INamed Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.INamedElement
   * @generated
   */
  public Adapter createINamedElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.basics.INamedCommentedElement <em>INamed Commented Element</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.basics.INamedCommentedElement
   * @generated
   */
  public Adapter createINamedCommentedElementAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for the default case.
   * <!-- begin-user-doc -->
   * This default implementation returns null.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @generated
   */
  public Adapter createEObjectAdapter()
  {
    return null;
  }

} //GeometryElementsAdapterFactory
