/**
 */
package org.fortiss.consistency.viewtypes.geometryElements.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.fortiss.consistency.viewtypes.basics.INamedCommentedElement;
import org.fortiss.consistency.viewtypes.basics.INamedElement;

import org.fortiss.consistency.viewtypes.geometryElements.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.geometryElements.GeometryElementsPackage
 * @generated
 */
public class GeometryElementsSwitch<T> extends Switch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static GeometryElementsPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public GeometryElementsSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = GeometryElementsPackage.eINSTANCE;
    }
  }

  /**
   * Checks whether this is a switch for the given package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param ePackage the package in question.
   * @return whether this is a switch for the given package.
   * @generated
   */
  @Override
  protected boolean isSwitchFor(EPackage ePackage)
  {
    return ePackage == modelPackage;
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  @Override
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case GeometryElementsPackage.GEOMETRY:
      {
        Geometry geometry = (Geometry)theEObject;
        T result = caseGeometry(geometry);
        if (result == null) result = caseINamedCommentedElement(geometry);
        if (result == null) result = caseINamedElement(geometry);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.GEOMETRY_ELEMENT:
      {
        GeometryElement geometryElement = (GeometryElement)theEObject;
        T result = caseGeometryElement(geometryElement);
        if (result == null) result = caseINamedCommentedElement(geometryElement);
        if (result == null) result = caseINamedElement(geometryElement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.PLACEHOLDER_ELEMENT:
      {
        PlaceholderElement placeholderElement = (PlaceholderElement)theEObject;
        T result = casePlaceholderElement(placeholderElement);
        if (result == null) result = caseGeometryElement(placeholderElement);
        if (result == null) result = caseINamedCommentedElement(placeholderElement);
        if (result == null) result = caseINamedElement(placeholderElement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.ORIGIN:
      {
        Origin origin = (Origin)theEObject;
        T result = caseOrigin(origin);
        if (result == null) result = caseGeometryElement(origin);
        if (result == null) result = caseINamedCommentedElement(origin);
        if (result == null) result = caseINamedElement(origin);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.SPHERE:
      {
        Sphere sphere = (Sphere)theEObject;
        T result = caseSphere(sphere);
        if (result == null) result = caseGeometryElement(sphere);
        if (result == null) result = caseINamedCommentedElement(sphere);
        if (result == null) result = caseINamedElement(sphere);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.CUBE:
      {
        Cube cube = (Cube)theEObject;
        T result = caseCube(cube);
        if (result == null) result = caseGeometryElement(cube);
        if (result == null) result = caseINamedCommentedElement(cube);
        if (result == null) result = caseINamedElement(cube);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.CUBOID:
      {
        Cuboid cuboid = (Cuboid)theEObject;
        T result = caseCuboid(cuboid);
        if (result == null) result = caseGeometryElement(cuboid);
        if (result == null) result = caseINamedCommentedElement(cuboid);
        if (result == null) result = caseINamedElement(cuboid);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case GeometryElementsPackage.PLANE:
      {
        Plane plane = (Plane)theEObject;
        T result = casePlane(plane);
        if (result == null) result = caseGeometryElement(plane);
        if (result == null) result = caseINamedCommentedElement(plane);
        if (result == null) result = caseINamedElement(plane);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Geometry</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Geometry</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseGeometry(Geometry object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Geometry Element</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Geometry Element</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseGeometryElement(GeometryElement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Placeholder Element</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Placeholder Element</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePlaceholderElement(PlaceholderElement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Origin</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Origin</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseOrigin(Origin object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Sphere</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Sphere</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSphere(Sphere object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Cube</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Cube</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCube(Cube object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Cuboid</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Cuboid</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCuboid(Cuboid object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Plane</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Plane</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePlane(Plane object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>INamed Element</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>INamed Element</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseINamedElement(INamedElement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>INamed Commented Element</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>INamed Commented Element</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseINamedCommentedElement(INamedCommentedElement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  @Override
  public T defaultCase(EObject object)
  {
    return null;
  }

} //GeometryElementsSwitch
