/**
 */
package org.fortiss.consistency.viewtypes.requirements;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.fortiss.consistency.viewtypes.basics.BasicsPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.requirements.RequirementsFactory
 * @model kind="package"
 * @generated
 */
public interface RequirementsPackage extends EPackage
{
  /**
   * The package name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNAME = "requirements";

  /**
   * The package namespace URI.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_URI = "http://www.fortiss.org/consistency/viewtypes/requirements";

  /**
   * The package namespace name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  String eNS_PREFIX = "org.fortiss.consistency.viewtypes.requirements";

  /**
   * The singleton instance of the package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  RequirementsPackage eINSTANCE = org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl.init();

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.requirements.impl.RequirementListImpl <em>Requirement List</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementListImpl
   * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getRequirementList()
   * @generated
   */
  int REQUIREMENT_LIST = 0;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_LIST__NAME = BasicsPackage.INAMED_COMMENTED_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Comment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_LIST__COMMENT = BasicsPackage.INAMED_COMMENTED_ELEMENT__COMMENT;

  /**
   * The feature id for the '<em><b>Contained Requirements</b></em>' reference list.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_LIST__CONTAINED_REQUIREMENTS = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The number of structural features of the '<em>Requirement List</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_LIST_FEATURE_COUNT = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_LIST___TO_STRING = BasicsPackage.INAMED_COMMENTED_ELEMENT___TO_STRING;

  /**
   * The number of operations of the '<em>Requirement List</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_LIST_OPERATION_COUNT = BasicsPackage.INAMED_COMMENTED_ELEMENT_OPERATION_COUNT + 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.requirements.impl.RequirementImpl <em>Requirement</em>}' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementImpl
   * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getRequirement()
   * @generated
   */
  int REQUIREMENT = 1;

  /**
   * The feature id for the '<em><b>Name</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__NAME = BasicsPackage.INAMED_COMMENTED_ELEMENT__NAME;

  /**
   * The feature id for the '<em><b>Comment</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__COMMENT = BasicsPackage.INAMED_COMMENTED_ELEMENT__COMMENT;

  /**
   * The feature id for the '<em><b>Requirements Id</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__REQUIREMENTS_ID = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 0;

  /**
   * The feature id for the '<em><b>Description</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__DESCRIPTION = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 1;

  /**
   * The feature id for the '<em><b>Rationale</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__RATIONALE = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 2;

  /**
   * The feature id for the '<em><b>Author</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__AUTHOR = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 3;

  /**
   * The feature id for the '<em><b>Priority</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__PRIORITY = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 4;

  /**
   * The feature id for the '<em><b>Status</b></em>' attribute.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT__STATUS = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 5;

  /**
   * The number of structural features of the '<em>Requirement</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_FEATURE_COUNT = BasicsPackage.INAMED_COMMENTED_ELEMENT_FEATURE_COUNT + 6;

  /**
   * The operation id for the '<em>To String</em>' operation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT___TO_STRING = BasicsPackage.INAMED_COMMENTED_ELEMENT___TO_STRING;

  /**
   * The number of operations of the '<em>Requirement</em>' class.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   * @ordered
   */
  int REQUIREMENT_OPERATION_COUNT = BasicsPackage.INAMED_COMMENTED_ELEMENT_OPERATION_COUNT + 0;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.requirements.RequirementStatus <em>Requirement Status</em>}' enum.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.requirements.RequirementStatus
   * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getRequirementStatus()
   * @generated
   */
  int REQUIREMENT_STATUS = 2;

  /**
   * The meta object id for the '{@link org.fortiss.consistency.viewtypes.requirements.Priority <em>Priority</em>}' enum.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see org.fortiss.consistency.viewtypes.requirements.Priority
   * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getPriority()
   * @generated
   */
  int PRIORITY = 3;


  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.requirements.RequirementList <em>Requirement List</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Requirement List</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.RequirementList
   * @generated
   */
  EClass getRequirementList();

  /**
   * Returns the meta object for the reference list '{@link org.fortiss.consistency.viewtypes.requirements.RequirementList#getContainedRequirements <em>Contained Requirements</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the reference list '<em>Contained Requirements</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.RequirementList#getContainedRequirements()
   * @see #getRequirementList()
   * @generated
   */
  EReference getRequirementList_ContainedRequirements();

  /**
   * Returns the meta object for class '{@link org.fortiss.consistency.viewtypes.requirements.Requirement <em>Requirement</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for class '<em>Requirement</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement
   * @generated
   */
  EClass getRequirement();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.requirements.Requirement#getRequirementsId <em>Requirements Id</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Requirements Id</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement#getRequirementsId()
   * @see #getRequirement()
   * @generated
   */
  EAttribute getRequirement_RequirementsId();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.requirements.Requirement#getDescription <em>Description</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Description</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement#getDescription()
   * @see #getRequirement()
   * @generated
   */
  EAttribute getRequirement_Description();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.requirements.Requirement#getRationale <em>Rationale</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Rationale</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement#getRationale()
   * @see #getRequirement()
   * @generated
   */
  EAttribute getRequirement_Rationale();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.requirements.Requirement#getAuthor <em>Author</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Author</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement#getAuthor()
   * @see #getRequirement()
   * @generated
   */
  EAttribute getRequirement_Author();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.requirements.Requirement#getPriority <em>Priority</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Priority</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement#getPriority()
   * @see #getRequirement()
   * @generated
   */
  EAttribute getRequirement_Priority();

  /**
   * Returns the meta object for the attribute '{@link org.fortiss.consistency.viewtypes.requirements.Requirement#getStatus <em>Status</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for the attribute '<em>Status</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Requirement#getStatus()
   * @see #getRequirement()
   * @generated
   */
  EAttribute getRequirement_Status();

  /**
   * Returns the meta object for enum '{@link org.fortiss.consistency.viewtypes.requirements.RequirementStatus <em>Requirement Status</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for enum '<em>Requirement Status</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.RequirementStatus
   * @generated
   */
  EEnum getRequirementStatus();

  /**
   * Returns the meta object for enum '{@link org.fortiss.consistency.viewtypes.requirements.Priority <em>Priority</em>}'.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the meta object for enum '<em>Priority</em>'.
   * @see org.fortiss.consistency.viewtypes.requirements.Priority
   * @generated
   */
  EEnum getPriority();

  /**
   * Returns the factory that creates the instances of the model.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the factory that creates the instances of the model.
   * @generated
   */
  RequirementsFactory getRequirementsFactory();

  /**
   * <!-- begin-user-doc -->
   * Defines literals for the meta objects that represent
   * <ul>
   *   <li>each class,</li>
   *   <li>each feature of each class,</li>
   *   <li>each operation of each class,</li>
   *   <li>each enum,</li>
   *   <li>and each data type</li>
   * </ul>
   * <!-- end-user-doc -->
   * @generated
   */
  interface Literals
  {
    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.requirements.impl.RequirementListImpl <em>Requirement List</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementListImpl
     * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getRequirementList()
     * @generated
     */
    EClass REQUIREMENT_LIST = eINSTANCE.getRequirementList();

    /**
     * The meta object literal for the '<em><b>Contained Requirements</b></em>' reference list feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EReference REQUIREMENT_LIST__CONTAINED_REQUIREMENTS = eINSTANCE.getRequirementList_ContainedRequirements();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.requirements.impl.RequirementImpl <em>Requirement</em>}' class.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementImpl
     * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getRequirement()
     * @generated
     */
    EClass REQUIREMENT = eINSTANCE.getRequirement();

    /**
     * The meta object literal for the '<em><b>Requirements Id</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REQUIREMENT__REQUIREMENTS_ID = eINSTANCE.getRequirement_RequirementsId();

    /**
     * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REQUIREMENT__DESCRIPTION = eINSTANCE.getRequirement_Description();

    /**
     * The meta object literal for the '<em><b>Rationale</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REQUIREMENT__RATIONALE = eINSTANCE.getRequirement_Rationale();

    /**
     * The meta object literal for the '<em><b>Author</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REQUIREMENT__AUTHOR = eINSTANCE.getRequirement_Author();

    /**
     * The meta object literal for the '<em><b>Priority</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REQUIREMENT__PRIORITY = eINSTANCE.getRequirement_Priority();

    /**
     * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    EAttribute REQUIREMENT__STATUS = eINSTANCE.getRequirement_Status();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.requirements.RequirementStatus <em>Requirement Status</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.requirements.RequirementStatus
     * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getRequirementStatus()
     * @generated
     */
    EEnum REQUIREMENT_STATUS = eINSTANCE.getRequirementStatus();

    /**
     * The meta object literal for the '{@link org.fortiss.consistency.viewtypes.requirements.Priority <em>Priority</em>}' enum.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see org.fortiss.consistency.viewtypes.requirements.Priority
     * @see org.fortiss.consistency.viewtypes.requirements.impl.RequirementsPackageImpl#getPriority()
     * @generated
     */
    EEnum PRIORITY = eINSTANCE.getPriority();

  }

} //RequirementsPackage
