/**
 */
package org.fortiss.consistency.viewtypes.types.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import org.fortiss.consistency.viewtypes.types.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see org.fortiss.consistency.viewtypes.types.TypesPackage
 * @generated
 */
public class TypesAdapterFactory extends AdapterFactoryImpl
{
  /**
   * The cached model package.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static TypesPackage modelPackage;

  /**
   * Creates an instance of the adapter factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TypesAdapterFactory()
  {
    if (modelPackage == null)
    {
      modelPackage = TypesPackage.eINSTANCE;
    }
  }

  /**
   * Returns whether this factory is applicable for the type of the object.
   * <!-- begin-user-doc -->
   * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
   * <!-- end-user-doc -->
   * @return whether this factory is applicable for the type of the object.
   * @generated
   */
  @Override
  public boolean isFactoryForType(Object object)
  {
    if (object == modelPackage)
    {
      return true;
    }
    if (object instanceof EObject)
    {
      return ((EObject)object).eClass().getEPackage() == modelPackage;
    }
    return false;
  }

  /**
   * The switch that delegates to the <code>createXXX</code> methods.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected TypesSwitch<Adapter> modelSwitch =
    new TypesSwitch<Adapter>()
    {
      @Override
      public Adapter caseIType(IType object)
      {
        return createITypeAdapter();
      }
      @Override
      public Adapter caseTypeBoolean(TypeBoolean object)
      {
        return createTypeBooleanAdapter();
      }
      @Override
      public Adapter caseTypeInteger(TypeInteger object)
      {
        return createTypeIntegerAdapter();
      }
      @Override
      public Adapter caseTypeDouble(TypeDouble object)
      {
        return createTypeDoubleAdapter();
      }
      @Override
      public Adapter caseTypeString(TypeString object)
      {
        return createTypeStringAdapter();
      }
      @Override
      public Adapter caseIValue(IValue object)
      {
        return createIValueAdapter();
      }
      @Override
      public Adapter caseValueBoolean(ValueBoolean object)
      {
        return createValueBooleanAdapter();
      }
      @Override
      public Adapter caseValueInteger(ValueInteger object)
      {
        return createValueIntegerAdapter();
      }
      @Override
      public Adapter caseValueDouble(ValueDouble object)
      {
        return createValueDoubleAdapter();
      }
      @Override
      public Adapter caseValueString(ValueString object)
      {
        return createValueStringAdapter();
      }
      @Override
      public Adapter caseNoValue(NoValue object)
      {
        return createNoValueAdapter();
      }
      @Override
      public Adapter defaultCase(EObject object)
      {
        return createEObjectAdapter();
      }
    };

  /**
   * Creates an adapter for the <code>target</code>.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param target the object to adapt.
   * @return the adapter for the <code>target</code>.
   * @generated
   */
  @Override
  public Adapter createAdapter(Notifier target)
  {
    return modelSwitch.doSwitch((EObject)target);
  }


  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.IType <em>IType</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.IType
   * @generated
   */
  public Adapter createITypeAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.TypeBoolean <em>Type Boolean</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.TypeBoolean
   * @generated
   */
  public Adapter createTypeBooleanAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.TypeInteger <em>Type Integer</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.TypeInteger
   * @generated
   */
  public Adapter createTypeIntegerAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.TypeDouble <em>Type Double</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.TypeDouble
   * @generated
   */
  public Adapter createTypeDoubleAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.TypeString <em>Type String</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.TypeString
   * @generated
   */
  public Adapter createTypeStringAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.IValue <em>IValue</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.IValue
   * @generated
   */
  public Adapter createIValueAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.ValueBoolean <em>Value Boolean</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.ValueBoolean
   * @generated
   */
  public Adapter createValueBooleanAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.ValueInteger <em>Value Integer</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.ValueInteger
   * @generated
   */
  public Adapter createValueIntegerAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.ValueDouble <em>Value Double</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.ValueDouble
   * @generated
   */
  public Adapter createValueDoubleAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.ValueString <em>Value String</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.ValueString
   * @generated
   */
  public Adapter createValueStringAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for an object of class '{@link org.fortiss.consistency.viewtypes.types.NoValue <em>No Value</em>}'.
   * <!-- begin-user-doc -->
   * This default implementation returns null so that we can easily ignore cases;
   * it's useful to ignore a case when inheritance will catch all the cases anyway.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @see org.fortiss.consistency.viewtypes.types.NoValue
   * @generated
   */
  public Adapter createNoValueAdapter()
  {
    return null;
  }

  /**
   * Creates a new adapter for the default case.
   * <!-- begin-user-doc -->
   * This default implementation returns null.
   * <!-- end-user-doc -->
   * @return the new adapter.
   * @generated
   */
  public Adapter createEObjectAdapter()
  {
    return null;
  }

} //TypesAdapterFactory
