<#macro recurse_macro node>
	<ul>
		<#list node.children as descriptor>
	    <li>
	    	<a href="#${descriptor.url}">${descriptor.name}</a>
	    	<#if descriptor.children?size != 0 >
		 		<@recurse_macro node=descriptor/>
		 	</#if>
	    </li>
	    </#list>
	</ul>
</#macro>

<html>
<head>
  <title>${title}</title>
  <style>
    body {
      background:white;
      font:normal normal 13px/1.4 Segoe,"Segoe UI",Calibri,Helmet,FreeSans,Sans-Serif;
    }

	.tree,
	.tree ul {
	  margin:0;
	  padding:0;
	  list-style:none;
	}

	.tree ul {
	  margin-left:1em; /* indentation */
	  position:relative;
	}

	.tree ul ul {margin-left:.5em} /* (indentation/2) */

	.tree ul:before {
	  content:"";
	  display:block;
	  width:0;
	  position:absolute;
	  top:0;
	  bottom:0;
	  left:0;
	  border-left:1px solid;
	}

	.tree li {
	  margin:0;
	  padding:0 1.5em; /* indentation + .5em */
	  line-height:2em; /* default list item's `line-height` */
	  color:#369;
	  font-weight:bold;
	  position:relative;
	}

	.tree ul li:before {
	  content:"";
	  display:block;
	  width:10px; /* same with indentation */
	  height:0;
	  border-top:1px solid;
	  margin-top:-1px; /* border top width */
	  position:absolute;
	  top:1em; /* (line-height/2) */
	  left:0;
	}

	.tree ul li:last-child:before {
	  background:#eeeeee; /* same with body background */
	  height:auto;
	  top:1em; /* (line-height/2) */
	  bottom:0;
	}

	.page-break {
    	page-break-after: always;
    }

	#header {
      background-color:gray;
      color:white;
      text-align:center;
      position:fixed;
      top: 0px;
      width: 100%;
      height: 60px;
  	}

  	#nav {
      background-color:#eeeeee;
      float:left;
      top:60px;
      width: 20%;
      height: 90%;
      position:fixed;
      overflow:auto;
  	}

	#section {
      float:left;
      top: 60px;
      width:80%;
      height: 90%;
      left: 400px;
      position: fixed;
      overflow:auto;
	}

	th {
		font-weight: bold;
		text-align: left;
		background-color: lightgray;
	}

	td {
		text-align: left;
    	width: 300px;
    	max-width:300px;
        min-width:300px;
        overflow:hidden;
	}

	</style>
</head>
<body>
 	<div id="header">
    <h1>${title}</h1>
	</div>
	<div id="nav">
		<h3>Components</h3>
		<ul class="tree">
			<#list descriptors as descriptor>
		    <li>
		    	<a href="#${descriptor.url}">${descriptor.name}</a>
		    	<@recurse_macro node=descriptor/>
		    </li>
		    </#list>
		</ul>
	</div>

	<div id="section">
    	<#list diagrams as diagram>
    	<a name="${diagram.url}"/>
	    <h1>${diagram.name}</h1>
	    <p>
	      <object data="${diagram.url}" type="image/svg+xml"></object>
	    </p>

	    <h2>Component description:</h2>
	    <table border="0" style="width:500px">
	       <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			  <th>Notes</th>
			</tr>
		  </thead>
		    <tbody>
	  		  <tr>
				<td>${diagram.component.name}</td>
				 <#if diagram.component.type?length != 0>
				  <td>${diagram.component.type}</td>
				 <#else>
				  <td></td>
		         </#if>
		         <#if diagram.component.refinementType?length != 0>
				  <td>${diagram.component.refinementType} refinement</td>
				 <#else>
				  <td></td>
		         </#if>
			  </tr>
			</tbody>
	    </table>
	    <br>

	    <#if (diagram.component.parameters?size != 0)>
 		<h3>Parameters:</h3>
	    <table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			</tr>
		  </thead>
		  <tbody>
		    <#list diagram.component.parameters as parameter>
			  <tr>
				<td>${parameter.name}</td>
				<td><i>${parameter.type}</i></td>
			  </tr>
			</#list>
		  </tbody>
		</table>
	    </#if>
 		<br>

 		<#if (diagram.component.inputPorts?size !=0 )>
 		<h3>Input ports:</h3>
	    <table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			  <th>Range</th>
			</tr>
		  </thead>
		  <tbody>
		    <#list diagram.component.inputPorts as inputPort>
			  <tr>
				<td>${inputPort.name}</td>
				<td><i>${inputPort.type}</i></td>
				<#if inputPort.range?length != 0>
				  <td><i> [${inputPort.range}]</i></td>
				<#else>
				  <td></td>
				</#if>
			  </tr>
			</#list>
		  </tbody>
		</table>
	    </#if>
 		<br>

		<#if (diagram.component.outputPorts?size != 0)>
		<h3>Output ports:</h3>
		<table border="0" style="width:500px">
		  <thead>
			<tr>
			  <th>Name</th>
			  <th>Type</th>
			  <th>Range</th>
			</tr>
		  </thead>
		  <tbody>
			<#list diagram.component.outputPorts as outputPort>
			  <tr>
				<td>${outputPort.name}</td>
				<td><i>${outputPort.type}</i></td>
				<#if outputPort.range?length != 0 >
				  <td><i> [${outputPort.range}]</i></td>
				<#else>
				  <td></td>
				</#if>
			  </tr>
			</#list>
		  </tbody>
		</table>
		</#if>

		<br>
		<#if (diagram.contracts?has_content)>
		  <#if (diagram.contracts?length != 0)>
	   	    <h3>Contracts:</h3>
	    	<pre>${diagram.contracts}</pre>
	      </#if>
	    </#if>
	    <br>
	    <p class="page-break"/>
		</#list>
	</div>
</body>
</html>