\documentclass[12pt]{article}
\usepackage{graphicx}
\usepackage{array}
\usepackage[T1]{fontenc}
\catcode`\_=12
\usepackage{float}

\begin{document}

\section* {${title}}

<#list diagrams as diagram>

\section{${diagram.name}}
\includegraphics[width=1.2\textwidth]{"${diagram.url_no_extension}"}

\subsection{Description}
Name: ${diagram.component.name}\\
Type: ${diagram.component.type}\\
Notes: <#if diagram.component.refinementType?length != 0> ${diagram.component.refinementType} refinement\\</#if>

<#if diagram.component.parameters?size!= 0>
\begin{table}[h!]
\caption {${diagram.component.name} parameters}
\begin{tabular}{ |m{15em}|m{15em}| }
\hline
 Name & Type \\
\hline
<#list diagram.component.parameters as parameter>
${parameter.name} & ${parameter.type} \\
</#list>
\hline
\end{tabular}
\end{table}
</#if>

<#if diagram.component.inputPorts?size!=0 >
\begin{table}[h!]
\caption {${diagram.component.name} input ports}
\begin{tabular}{ |m{15em}|m{5em}|m{15em}| }
\hline
 Name & Type & Range \\
\hline
<#list diagram.component.inputPorts as inputPort>
${inputPort.name} & ${inputPort.type} & ${inputPort.range} \\
</#list>
\hline
\end{tabular}
\end{table}
</#if>

<#if diagram.component.outputPorts?size!=0 >
\begin{table}[h!]
\caption {${diagram.component.name} output ports}
\begin{tabular}{ |m{15em}|m{5em}|m{15em}| }
\hline
 Name & Type & Range \\
\hline
<#list diagram.component.outputPorts as outputPort>
${outputPort.name} & ${outputPort.type} & ${outputPort.range} \\
</#list>
\hline
\end{tabular}
\end{table}
</#if>

</#list>

\end{document}