/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

/**
 * Enumeration for shared images.
 * 
 * @author hoelzl
 */
public enum ESharedImages {

	/** Fatal overlay icon. */
	FATAL_OVERLAY,

	/** Error overlay icon. */
	ERROR_OVERLAY,

	/** Warning overlay icon. */
	WARNING_OVERLAY,

	/** Tutorial (closed book) image. */
	TUTORIAL_TODO,

	/** Tutorial (open book) image. */
	TUTORIAL,

	/** The OK image. */
	OK,

	/** The navigator image. */
	NAVIGATOR,

	/** Library image. */
	LIBRARY,

	/** Error (non-overlay) icon. */
	ERROR,

	/** Warning (non-overlay) icon. */
	WARNING;

	/**
	 * Register all images defined in this enumeration with the given image
	 * registry. This needs to be called only once.
	 */
	/* package */static void registerImages(ImageRegistry registry) {
		for(ESharedImages image : values()) {
			registry.put(image.name(),
					ToolingKernelUIActivator.getImageDescriptor(image.getImagePath()));
		}
	}

	/** Get image registry from {@link ToolingKernelUIActivator}. */
	private static ImageRegistry getRegistry() {
		return ToolingKernelUIActivator.getDefault().getImageRegistry();
	}

	/** Get image for enumeration element. */
	public Image getImage() {
		return getRegistry().get(name());
	}

	/** Get image descriptor for enumeration element. */
	public ImageDescriptor getImageDescriptor() {
		return getRegistry().getDescriptor(name());
	}

	/** Get path to image. */
	private String getImagePath() {
		return "icons/" + name().toLowerCase() + ".png";
	}
}
