/*-------------------------------------------------------------------------+
| Copyright 2016 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui;

import static org.fortiss.tooling.kernel.ui.internal.ToolingKernelUIInternal.initializeKernelUI;
import static org.fortiss.tooling.kernel.ui.internal.ToolingKernelUIInternal.startKernelUI;

/**
 * Class for initializing and starting the user interface part of the tooling kernel.
 * 
 * @author hoelzl
 */
public final class ToolingKernelUI {
	/** Initializes the UI services. */
	public static void initialize() {
		initializeKernelUI();
	}

	/** Starts the UI services. */
	public static void start() {
		startKernelUI();
	}
}
