/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui;

import static org.eclipse.jface.resource.ResourceLocator.imageDescriptorFromBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.fortiss.tooling.kernel.ui.internal.TutorialUIService;
import org.fortiss.tooling.kernel.ui.service.IActionService;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;
import org.fortiss.tooling.kernel.ui.service.IMarkerService;
import org.fortiss.tooling.kernel.ui.service.IModelEditorBindingService;
import org.fortiss.tooling.kernel.ui.service.IModelElementHandlerService;
import org.fortiss.tooling.kernel.ui.service.INavigatorService;
import org.osgi.framework.BundleContext;

import javafx.scene.image.ImageView;

/**
 * The activator class controls the plug-in life cycle.
 * 
 * @author hoelzl
 */
public class ToolingKernelUIActivator extends AbstractUIPlugin {

	/** The plug-in ID. */
	public static final String PLUGIN_ID = ToolingKernelUIActivator.class.getPackage().getName(); // $NON-NLS-1$

	/** The shared instance. */
	private static ToolingKernelUIActivator plugin;

	/** {@inheritDoc} */
	@Override
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin = this;
		System.out.println("[Plugin] " + PLUGIN_ID + " started.");

		initializeServices();
	}

	/** Initializes UI services by calling its singleton reference {@code toString()}. */
	private void initializeServices() {
		IActionService.getInstance().toString();
		IContextMenuService.getInstance().toString();
		IMarkerService.getInstance().toString();
		IModelEditorBindingService.getInstance().toString();
		IModelElementHandlerService.getInstance().toString();
		INavigatorService.getInstance().toString();
	}

	/** {@inheritDoc} */
	@Override
	public void stop(BundleContext context) throws Exception {
		TutorialUIService.getInstance().stopLocallyStartedTutorialBundles();
		getImageRegistry().dispose();
		plugin = null;
		super.stop(context);
	}

	/** Returns the shared instance. */
	public static ToolingKernelUIActivator getDefault() {
		return plugin;
	}

	/** Returns image descriptor of the image in the kernel plugin. */
	public static ImageDescriptor getImageDescriptor(String iconPath) {
		return imageDescriptorFromBundle(PLUGIN_ID, iconPath).orElse(null);
	}

	/** {@inheritDoc} */
	@Override
	protected void initializeImageRegistry(ImageRegistry registry) {
		ESharedImages.registerImages(registry);
	}

	/** Returns an FX {@link ImageView} for the given icon path. Null otherwise. */
	public static ImageView getFXImage(String iconPath) {
		try {
			ImageView iv = new ImageView(iconPath);
			return iv;
		} catch(NullPointerException | IllegalArgumentException e) {
			return null;
		}
	}
}
