/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.databinding;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.widgets.Composite;
import org.fortiss.tooling.kernel.ui.editor.StyledTextCellEditor;
import org.fortiss.tooling.kernel.ui.extension.base.EditorBase;

/**
 * Abstract base class for inline text cell, with copy-paste support.
 * 
 * @author hoelzl
 */
public abstract class AbstractStyledTextCellDatabindingEditingSupport
		extends AbstractTextCellDatabindingEditingSupport {

	/** Editor, which contains this EditingSupport}. */
	protected EditorBase<? extends EObject> editor;

	/** Constructor. */
	public AbstractStyledTextCellDatabindingEditingSupport(EditorBase<? extends EObject> editor,
			ColumnViewer viewer, DataBindingContext bindingContext) {
		super(viewer, bindingContext);
		this.editor = editor;
	}

	/** {@inheritDoc} */
	@Override
	protected CellEditor createCellEditor(ColumnViewer viewer) {
		CellEditor cellEditor = new StyledTextCellEditor(editor.getTextStyledTextActionHandler(),
				(Composite)getViewer().getControl());
		setupCellEditor(cellEditor);
		return cellEditor;
	}
}
