/*-------------------------------------------------------------------------+
| Copyright 2012 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.databinding;

import static java.text.NumberFormat.getNumberInstance;

/**
 * Validator to check if a number is an floating point number.
 * 
 * @author hoelzl, barner
 */
public class FloatValidator extends NumberValidator {

	/** {@link FloatValidator} singleton instance. */
	public static final FloatValidator FLOAT_VALIDATOR = new FloatValidator();

	/** Constructor. */
	private FloatValidator() {
		super(getNumberInstance());
	}

	/** {@inheritDoc} */
	@Override
	protected String getFormatName() {
		return "Floating point";
	}
}
