/*-------------------------------------------------------------------------+
| Copyright 2012 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.databinding;

import java.text.NumberFormat;

/**
 * Validator to check if a number is an integer.
 * 
 * @author hoelzl, barner
 */
public class IntValidator extends NumberValidator {

	/** {@link IntValidator} singleton instance. */
	public static final IntValidator INT_VALIDATOR = new IntValidator();

	/** Constructor. */
	private IntValidator() {
		super(NumberFormat.getIntegerInstance());
	}

	/** {@inheritDoc} */
	@Override
	protected String getFormatName() {
		return "Integer";
	}
}
