/*-------------------------------------------------------------------------+
| Copyright 2018 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.databinding;

import static org.eclipse.core.databinding.validation.ValidationStatus.cancel;
import static org.eclipse.core.databinding.validation.ValidationStatus.ok;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;

/**
 * {@link IValidator} for checking that a numeric value is positive or zero.
 * 
 * @author barner
 */
public class NumberPositiveZeroValidator extends NumberValueValidatorBase {

	/** Singleton instance. */
	public static final NumberPositiveZeroValidator NUMBER_POSITIVE_ZERO_VALIDATOR =
			new NumberPositiveZeroValidator();

	/** {@inheritDoc} */
	@Override
	protected IStatus doValidate(Number number) {
		if(number.doubleValue() < 0) {
			return cancel("Value must be >= 0");
		}

		return ok();
	}
}
