/*-------------------------------------------------------------------------+
| Copyright 2018 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.databinding;

import static org.eclipse.core.databinding.validation.ValidationStatus.cancel;
import static org.eclipse.core.databinding.validation.ValidationStatus.ok;
import static org.fortiss.tooling.kernel.utils.LoggingUtils.error;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.fortiss.tooling.kernel.ToolingKernelActivator;

/**
 * Base class for {@link IValidator}s to check the value of {@link Number}s.
 * 
 * @author barner
 */
public abstract class NumberValueValidatorBase implements IValidator {

	/** {@inheritDoc} */
	@Override
	public final IStatus validate(Object value) {
		if(value == null) {
			return ok();
		}

		if(!(value instanceof Number)) {
			String typeName = value.getClass().getSimpleName();
			error(ToolingKernelActivator.getDefault(), "Value \"" + value.toString() +
					"\" is not a number but of type " + typeName + ".");
			return cancel("Value is not a number");
		}

		return doValidate((Number)value);
	}

	/** Checks the value of the provided {@link Number}. */
	protected abstract IStatus doValidate(Number number);
}
