/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.dnd;

import org.eclipse.gef.dnd.SimpleObjectTransfer;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

/**
 * A {@link SimpleObjectTransfer} singleton used for Copy&Paste via
 * {@link IElementCompositorService}.
 * 
 * Although this class is practically identical to {@link CompositionServiceLocalDNDTransfer}, both
 * classes are needed. This one
 * for one for copy paste object transfer and that one for drag and drop object
 * transfer.
 * 
 * @author hoelzl
 */
public class CompositionServiceLocalCopyPasteTransfer extends SimpleObjectTransfer {
	/** Singleton instance. */
	private static final CompositionServiceLocalCopyPasteTransfer INSTANCE =
			new CompositionServiceLocalCopyPasteTransfer();
	/** Transfer type name. */
	private static final String TYPE_NAME =
			CompositionServiceLocalCopyPasteTransfer.class.getName();
	/** Transfer type ID. */
	private static final int TYPEID = registerType(TYPE_NAME);

	/** Returns the singleton instance. */
	public static CompositionServiceLocalCopyPasteTransfer getInstance() {
		return INSTANCE;
	}

	/** {@inheritDoc} */
	@Override
	protected int[] getTypeIds() {
		return new int[] {TYPEID};
	}

	/** {@inheritDoc} */
	@Override
	protected String[] getTypeNames() {
		return new String[] {TYPE_NAME};
	}
}
