/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.dnd;

import org.eclipse.gef.dnd.SimpleObjectTransfer;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

/**
 * A {@link SimpleObjectTransfer} singleton used for DND via {@link IElementCompositorService} and
 * {@link IConnectionCompositorService}.
 * 
 * Although this class is practically identical to {@link CompositionServiceLocalCopyPasteTransfer},
 * both classes are needed.
 * This one for drag and drop object transfer and that one for copy paste object
 * transfer.
 * 
 * @author hoelzl
 */
public class CompositionServiceLocalDNDTransfer extends SimpleObjectTransfer {
	/** Singleton instance. */
	private static final CompositionServiceLocalDNDTransfer INSTANCE =
			new CompositionServiceLocalDNDTransfer();
	/** Transfer type name. */
	private static final String TYPE_NAME = CompositionServiceLocalDNDTransfer.class.getName();
	/** Transfer type ID. */
	private static final int TYPEID = registerType(TYPE_NAME);

	/** Returns the singleton instance. */
	public static CompositionServiceLocalDNDTransfer getInstance() {
		return INSTANCE;
	}

	/** {@inheritDoc} */
	@Override
	protected int[] getTypeIds() {
		return new int[] {TYPEID};
	}

	/** {@inheritDoc} */
	@Override
	protected String[] getTypeNames() {
		return new String[] {TYPE_NAME};
	}
}
