/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.dnd;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceAdapter;

/**
 * {@link DragSourceAdapter} for initiating an EObject connection via drag
 * gesture. The implementation takes a source object provided by {@link #getSourceElement()} and the
 * designated parent by {@link #getParentElement()}, and transfers an
 * {@link ConnectionCompositionSource} object via {@link CompositionServiceLocalDNDTransfer}.
 * <p>
 * This implementation uses the raw SWT DND mechanism.
 * 
 * 
 * @author hoelzl
 */
public abstract class ConnectionCompositionDragSourceAdapter
		extends ElementCompositionDragSourceAdapter {

	/** Returns the designated parent element used for linking. */
	protected abstract EObject getParentElement();

	/** Returns the supported DND operations as defined in {@link DND}. */
	@Override
	public int getSupportedDNDOperations() {
		return DND.DROP_LINK;
	}

	/** Creates the object to be transfered. */
	@Override
	protected ConnectionCompositionSource createData(EObject data) {
		return new ConnectionCompositionSource(data, getParentElement());
	}
}
