/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.dnd;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;

/**
 * DND transfer object for EObject connection composition. If an object of this
 * class is transfered via DND, the drop target usually uses the information
 * contained herein to call the {@link IConnectionCompositorService}.
 * 
 * @author hoelzl
 */
public class ConnectionCompositionSource extends ElementCompositionSource {
	/** Stores the parent element for use in connection composition. */
	private final EObject parentElement;

	/** Constructor. */
	public ConnectionCompositionSource(EObject element, EObject parent) {
		super(element);
		this.parentElement = parent;
	}

	/** Returns the designated parent element. */
	public EObject getDesignatedParentElement() {
		return parentElement;
	}
}
