/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.dnd;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.Transfer;

/**
 * DND {@link DragSourceAdapter} for initiating an EObject composition via drag
 * gesture. The implementation takes a source model element provided by {@link #getSourceElement()}
 * and transfers an {@link ElementCompositionSource} object using
 * {@link CompositionServiceLocalDNDTransfer}.
 * <p>
 * This implementation uses the raw SWT DND mechanism.
 * 
 * @author hoelzl
 */
public abstract class ElementCompositionDragSourceAdapter extends DragSourceAdapter {

	/** Returns the selected element of this drag source adapter. */
	protected abstract EObject getSourceElement();

	/** Returns the supported DND operations as defined in {@link DND}. */
	public int getSupportedDNDOperations() {
		return DND.DROP_COPY;
	}

	/** Returns the preferred transfer for the DND operation. */
	public Transfer getPreferredTransfer() {
		return CompositionServiceLocalDNDTransfer.getInstance();
	}

	/** {@inheritDoc} */
	@Override
	public void dragStart(DragSourceEvent event) {
		EObject source = getSourceElement();
		event.doit = source != null;
		event.data = source != null ? createData(source) : null;
		CompositionServiceLocalDNDTransfer.getInstance().setObject(event.data);
	}

	/** {@inheritDoc} */
	@Override
	public void dragSetData(DragSourceEvent event) {
		event.data = createData(getSourceElement());
	}

	/** Creates the object to be transfered. */
	protected ElementCompositionSource createData(EObject data) {
		return new ElementCompositionSource(data);
	}
}
