/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.dnd;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

/**
 * DND transfer object for EObject element composition. If an object of this
 * class is transfered via DND, the drop target usually uses the information
 * contained herein to call the {@link IElementCompositorService}.
 * 
 * @author hoelzl
 */
public class ElementCompositionSource {

	/** Stores the element designated for composition. */
	private EObject element;

	/** Constructor. */
	public ElementCompositionSource(EObject element) {
		this.element = element;
	}

	/** Returns the designated element. */
	public EObject getDesignatedElement() {
		return element;
	}
}
