/*-------------------------------------------------------------------------+
| Copyright 2013 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.editor;

import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.TextStyledTextActionHandler;

/**
 * A {@link TextCellEditor} with styled text fields and copy-paste keyboard shortcut support.
 * 
 * @author wenwenchen
 */
public class StyledTextCellEditor extends TextCellEditor {

	/** Text action handler for text fields and styled text fields with copy-paste key function. */
	private TextStyledTextActionHandler textStyledTextActionHandler;

	/**
	 * Constructor.
	 * 
	 * @param textStyledTextActionHandler
	 *            text action handler for text fields and styled text fields
	 * @param parent
	 *            parent composite
	 */
	public StyledTextCellEditor(TextStyledTextActionHandler textStyledTextActionHandler,
			Composite parent) {
		super();
		this.textStyledTextActionHandler = textStyledTextActionHandler;
		create(parent);
	}

	/** {@inheritDoc} */
	@Override
	protected Control createControl(Composite parent) {
		Control control = super.createControl(parent);
		textStyledTextActionHandler.addText(text);
		return control;
	}
}
