/*-------------------------------------------------------------------------+
| Copyright 2011 fortiss GmbH                                              |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package org.fortiss.tooling.kernel.ui.extension;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IContributionItem;
import org.fortiss.tooling.kernel.ui.extension.data.ContextMenuContextProvider;
import org.fortiss.tooling.kernel.ui.service.IContextMenuService;

/**
 * Classes implementing this interface contribute custom menu entries or
 * sub-menus to the context menu provided by the {@link IContextMenuService}.
 * The contribution can be dependent on a context provided by a {@link ContextMenuContextProvider},
 * which is usually the workbench part
 * showing the context menu. It may also take into account the currently
 * selected model element or an independent application state determined in a
 * contributor-specific way.
 * 
 * @see IContextMenuService
 * 
 * @author hoelzl
 */
public interface IContextMenuContributor {

	/**
	 * Returns the contributed items, i.e., actions or menus in the context of
	 * the given provider and the given selected model element. The selection
	 * may be null, but is always equal to
	 * {@link ContextMenuContextProvider#getSelectedModelElement()}.
	 */
	List<IContributionItem> getContributedItems(EObject selection,
			ContextMenuContextProvider contextProvider);

	/** Returns the section ID to be used for the contributed elements. */
	String getMenuSectionID();

	/**
	 * Returns true if this context menu provider should be hidden in the navigator's simplified
	 * non-expert view.
	 */
	default boolean hiddenInNonExpertView() {
		return false;
	}
}
